<head>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }

        table {
            font-size: 14px;
            white-space: nowrap;
            /* Mencegah teks tabel melompat ke baris baru */
        }

        .table-responsive {
            overflow-x: auto;
            /* Menjadikan tabel bisa di-scroll jika terlalu lebar */
        }
    </style>
</head>

<body>
    <div class="card shadow-sm border-0">
        <div class="card-body" style="font-family: poppins;">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="text-dark">Daftar Ruang</h5>
                <a href="<?php echo base_url('/adminruangan_tambah'); ?>" class="btn btn-primary">+ Tambah Ruang</a>
            </div>

            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light text-center">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Kode Ruang</th>
                            <th scope="col">Nama Ruang</th>
                            <th scope="col">Kapasitas</th>
                            <th scope="col">Jenis Ruang</th>
                            <th scope="col">Foto</th>
                            <th scope="col">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1; ?>
                        <?php foreach ($ruangan as $r) : ?>
                            <tr class="text-center">
                                <th scope="row"><?= $no++; ?></th>
                                <td><?= esc($r['kode_ruang']); ?></td>
                                <td><?= esc($r['nama_ruang']); ?></td>
                                <td><?= esc($r['kapasitas']); ?></td>
                                <td><?= esc($r['jenis_ruang']); ?></td>
                                <td>
                                    <img src="<?= base_url($r['foto']); ?>" alt="Foto Ruang" width="50" class="img-fluid">

                                </td>
                                <td>
                                    <a href="<?= base_url('adminruangan_detail/' . $r['kode_ruang']); ?>" class="btn btn-info btn-sm">Detail</a>
                                    <a href="<?= base_url('adminruangan_delete/' . $r['kode_ruang']); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus ruangan ini?')">Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div> <!-- Akhir table-responsive -->

        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>