<!-- Simpan file ini sebagai alert.php di folder Views/components atau sesuai struktur folder Anda -->

<!-- Cek apakah ada alert yang perlu ditampilkan -->
<?php if (session()->has('swal_alert')) : ?>
    <?php $alert = session()->get('swal_alert'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            Swal.fire({
                icon: '<?= $alert['type'] ?>',
                title: '<?= $alert['title'] ?>',
                text: '<?= $alert['text'] ?>',
                footer: '<?= isset($alert['footer']) ? $alert['footer'] : '' ?>',
                confirmButtonColor: '<?= $alert['type'] === 'success' ? '#28a745' : ($alert['type'] === 'warning' ? '#ffc107' : '#dc3545') ?>',
                confirmButtonText: 'OK'
            });
        });
    </script>
<?php endif; ?>

<!-- Pastikan untuk menyertakan SweetAlert2 di layout utama Anda -->
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> -->