<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $judul_laporan ?> - Fakultas Kesehatan UDINUS</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');

        body {
            font-family: 'Poppins', sans-serif;
            font-size: 12pt;
            line-height: 1.6;
        }

        .letterhead {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
            border-bottom: 3px solid #0d6efd;
            padding-bottom: 15px;
        }

        .logo {
            width: 100px;
            height: auto;
            margin-right: 20px;
        }

        .letterhead-text {
            flex-grow: 1;
        }

        .letterhead-text h1 {
            font-size: 20pt;
            font-weight: 700;
            margin: 0;
            color: #0d6efd;
            text-transform: uppercase;
        }

        .letterhead-text h2 {
            font-size: 16pt;
            font-weight: 600;
            margin: 0;
            color: #212529;
        }

        .letterhead-text p {
            font-size: 9pt;
            margin: 0;
            color: #6c757d;
        }

        .report-header {
            margin-bottom: 25px;
            text-align: center;
            padding-bottom: 10px;
        }

        .report-header h2 {
            margin-bottom: 5px;
            font-weight: 700;
            color: #0d6efd;
            text-transform: uppercase;
        }

        .report-header h3 {
            font-weight: 600;
            color: #495057;
        }

        .report-info {
            margin-bottom: 20px;
            background-color: #f8f9fa;
            padding: 10px 15px;
            border-radius: 5px;
            border-left: 4px solid #0d6efd;
        }

        .report-info p {
            margin-bottom: 5px;
            font-size: 11pt;
        }

        .table-data {
            width: 100%;
            border-collapse: collapse;
            font-size: 10pt;
        }

        .table-data th,
        .table-data td {
            border: 1px solid #dee2e6;
            padding: 8px;
        }

        .table-data th {
            background-color: #0d6efd;
            color: white;
            text-align: center;
            font-weight: 600;
            vertical-align: middle;
        }

        .table-data tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .table-data tr:hover {
            background-color: #e9ecef;
        }

        .page-footer {
            margin-top: 30px;
            text-align: right;
            font-style: italic;
            font-size: 9pt;
            color: #6c757d;
            border-top: 1px solid #dee2e6;
            padding-top: 10px;
        }

        .summary-section {
            margin: 20px 0;
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            justify-content: center;
        }

        .summary-box {
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 10px;
            width: 180px;
            text-align: center;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            transition: transform 0.2s;
        }

        .summary-box:hover {
            transform: translateY(-3px);
        }

        .summary-title {
            font-weight: 600;
            margin-bottom: 5px;
            color: #495057;
            font-size: 10pt;
        }

        .summary-value {
            font-size: 18px;
            font-weight: 700;
            color: #0d6efd;
        }

        .box-primary {
            border-top: 3px solid #0d6efd;
        }

        .box-success {
            border-top: 3px solid #198754;
        }

        .box-warning {
            border-top: 3px solid #ffc107;
        }

        .box-danger {
            border-top: 3px solid #dc3545;
        }

        .signature-section {
            margin-top: 50px;
            text-align: right;
            width: 250px;
            float: right;
        }

        .signature-line {
            margin-top: 70px;
            border-top: B1px solid #000;
        }

        .btn-print {
            background-color: #0d6efd;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: 500;
            transition: background-color 0.2s;
        }

        .btn-print:hover {
            background-color: #0b5ed7;
        }

        .btn-back {
            background-color: #6c757d;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: 500;
            transition: background-color 0.2s;
            text-decoration: none;
            display: inline-block;
        }

        .btn-back:hover {
            background-color: #5c636a;
            color: white;
        }

        @media print {
            body {
                font-size: 12pt;
            }

            .no-print {
                display: none;
            }

            .page-break {
                page-break-before: always;
            }

            .table-data th {
                background-color: #e9ecef !important;
                color: #212529 !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .summary-value {
                color: #212529 !important;
            }

            .letterhead {
                border-bottom: 3px solid #212529;
            }

            .letterhead-text h1 {
                color: #212529;
            }

            .report-header h2 {
                color: #212529;
            }

            .report-info {
                border-left: 4px solid #212529;
            }
        }
    </style>
</head>

<body>
    <div class="container-fluid py-3">
        <!-- Print Button (only visible on screen) -->
        <div class="no-print mb-3">
            <button onclick="window.print()" class="btn-print">
                <i class="fas fa-print me-1"></i> Cetak Laporan
            </button>
            <a href="<?= base_url('/laporan_peminjaman') ?>" class="btn-back">
                <i class="fas fa-arrow-left me-1"></i> Kembali
            </a>
        </div>

        <!-- Letterhead -->
        <div class="letterhead">
            <img src="<?= base_url('assets/img/logo.png') ?>" alt="Logo UDINUS" class="logo">
            <div class="letterhead-text">
                <h1>Universitas Dian Nuswantoro</h1>
                <h2>Fakultas Kesehatan</h2>
                <p>Jl. Imam Bonjol No. 207, Pendrikan Kidul, Kec. Semarang Tengah, Kota Semarang, Jawa Tengah 50131</p>
                <p>Telp: (024) 3517261 | Email: fkes@dinus.ac.id | Website: fkes.dinus.ac.id</p>
            </div>
        </div>

        <!-- Report Header -->
        <div class="report-header">
            <h2>Laporan Peminjaman Ruangan</h2>
            <h3>Fakultas Kesehatan UDINUS</h3>
        </div>

        <!-- Report Info -->
        <div class="report-info">
            <p><i class="fas fa-calendar-alt me-2"></i><strong>Tanggal Cetak:</strong> <?= date('d-m-Y H:i', strtotime($tanggal_cetak)) ?></p>
            <?php if (isset($tanggal_mulai) && isset($tanggal_akhir)): ?>
                <p><i class="fas fa-filter me-2"></i><strong>Periode:</strong> <?= date('d-m-Y', strtotime($tanggal_mulai)) ?> s/d <?= date('d-m-Y', strtotime($tanggal_akhir)) ?></p>
            <?php endif; ?>
        </div>

        <!-- Summary Section -->
        <div class="summary-section">
            <?php
            $total = isset($peminjaman) ? count($peminjaman) : 0;
            $disetujui = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                return $p['status'] === 'Disetujui';
            })) : 0;
            $diproses = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                return $p['status'] === 'Diproses';
            })) : 0;
            $ditolak = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                return $p['status'] === 'Ditolak';
            })) : 0;
            ?>
            <div class="summary-box box-primary">
                <div class="summary-title"><i class="fas fa-clipboard-list me-1"></i>Total Peminjaman</div>
                <div class="summary-value"><?= $total ?></div>
            </div>
            <div class="summary-box box-success">
                <div class="summary-title"><i class="fas fa-check-circle me-1"></i>Disetujui</div>
                <div class="summary-value"><?= $disetujui ?></div>
            </div>
            <div class="summary-box box-warning">
                <div class="summary-title"><i class="fas fa-clock me-1"></i>Diproses</div>
                <div class="summary-value"><?= $diproses ?></div>
            </div>
            <div class="summary-box box-danger">
                <div class="summary-title"><i class="fas fa-times-circle me-1"></i>Ditolak</div>
                <div class="summary-value"><?= $ditolak ?></div>
            </div>
        </div>

        <!-- Table Data -->
        <table class="table-data">
            <thead>
                <tr>
                    <th width="5%">No.</th>
                    <th width="8%">Kode Ruang</th>
                    <th width="15%">Nama Ruang</th>
                    <th width="12%">Tanggal Mulai</th>
                    <th width="12%">Tanggal Selesai</th>
                    <th width="18%">Nama Kegiatan</th>
                    <th width="17%">Nama Organisasi</th>
                    <th width="13%">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $no = 1; ?>
                <?php if (isset($peminjaman) && $peminjaman): ?>
                    <?php foreach ($peminjaman as $pinjam): ?>
                        <tr>
                            <td style="text-align: center;"><?= $no++ ?></td>
                            <td style="text-align: center;"><?= esc($pinjam['kode_ruang']) ?></td>
                            <td><?= esc($pinjam['nama_ruang']) ?></td>
                            <td style="text-align: center;">
                                <?= date('d-m-Y', strtotime(esc($pinjam['tanggal_mulai']))) ?>
                            </td>
                            <td style="text-align: center;">
                                <?= date('d-m-Y', strtotime(esc($pinjam['tanggal_selesai']))) ?>
                            </td>
                            <td><?= esc($pinjam['nama_kegiatan']) ?></td>
                            <td><?= esc($pinjam['nama_organisasi']) ?></td>
                            <td style="text-align: center;">
                                <?php
                                $statusClass = '';
                                $statusIcon = '';

                                switch (esc($pinjam['status'])) {
                                    case 'Disetujui':
                                        $statusClass = 'text-success';
                                        $statusIcon = 'fas fa-check-circle';
                                        break;
                                    case 'Diproses':
                                        $statusClass = 'text-warning';
                                        $statusIcon = 'fas fa-clock';
                                        break;
                                    case 'Ditolak':
                                        $statusClass = 'text-danger';
                                        $statusIcon = 'fas fa-times-circle';
                                        break;
                                }
                                ?>
                                <span class="<?= $statusClass ?>">
                                    <i class="<?= $statusIcon ?> me-1"></i>
                                    <?= esc($pinjam['status']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" style="text-align: center;">
                            <div class="py-3">
                                <i class="fas fa-folder-open fa-2x text-muted mb-2"></i>
                                <p class="mb-0">Tidak ada data peminjaman ditemukan.</p>
                            </div>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Signature Section -->
        <div class="signature-section">
            <p>Semarang, <?= date('d F Y') ?><br>
               Kepala Tata Usaha<br>
                Fakultas Kesehatan</p>

            <div class="signature-line"></div>
            <p>(___________________)</p>
        </div>

        <!-- Page Footer -->
        <div class="page-footer">
            <p>Sistem Peminjaman Ruangan Fakultas Kesehatan UDINUS | Dicetak pada: <?= date('d-m-Y H:i:s', strtotime($tanggal_cetak)) ?></p>
        </div>
    </div>

    <!-- Print Automatically -->
    <script>
        // Uncomment this line to automatically print when page loads
        // window.onload = function() { window.print(); }
    </script>
</body>

</html>