<?php
include "koneksimysql.php";
header('Content-Type: application/json');

// Ambil data JSON dari body request
$data = json_decode(file_get_contents('php://input'), true);

// Periksa apakah data valid
if (isset($data['email'], $data['password'])) {
    $email = trim($data['email']);
    $password = trim($data['password']);

    $getstatus = 0;
    $getresult = 0;
    $message = "";
    $user_data = null;

    // Validasi email dan password tidak boleh kosong
    if (empty($email) || empty($password)) {
        echo json_encode(array('status' => 0, 'result' => 0, 'message' => "Email dan password tidak boleh kosong!"));
        exit;
    }

    // Cari user berdasarkan email
    $sql = "SELECT id_user, nama_user, email, password, nomerinduk, no_hp FROM user WHERE email = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $email);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($row = mysqli_fetch_assoc($result)) {
        // Verifikasi password
        if (password_verify($password, $row['password'])) {
            // Password benar
            $getstatus = 1;
            $getresult = 1;
            $message = "Login berhasil";

            // Hapus password dari data yang akan dikirim
            unset($row['password']);
            $user_data = $row;
        } else {
            // Password salah
            $getstatus = 0;
            $getresult = 0;
            $message = "Email atau password salah";
        }
    } else {
        // Email tidak ditemukan
        $getstatus = 0;
        $getresult = 0;
        $message = "Email atau password salah";
    }

    // Mengembalikan response dalam format JSON
    $response = array(
        'status' => $getstatus,
        'result' => $getresult,
        'message' => $message
    );

    // Tambahkan data user jika login berhasil
    if ($user_data) {
        $response['data'] = $user_data;
    }

    echo json_encode($response);
} else {
    // Jika parameter email atau password tidak ada
    echo json_encode(array('status' => 0, 'result' => 0, 'message' => "Email dan password diperlukan!"));
}
