<?php
include "koneksimysql.php";
header('content-type: application/json');

// Query untuk total ruang
$sql = "SELECT COUNT(*) as jumlah_ruang FROM ruang";
$hasil = mysqli_query($conn, $sql);

if ($hasil) {
    $data = mysqli_fetch_object($hasil);

    // Query tambahan untuk breakdown per jenis ruang
    $sql_detail = "SELECT jenis_ruang, COUNT(*) as jumlah 
                   FROM ruang 
                   GROUP BY jenis_ruang 
                   ORDER BY jumlah DESC";
    $hasil_detail = mysqli_query($conn, $sql_detail);

    $breakdown = array();
    while ($detail = mysqli_fetch_object($hasil_detail)) {
        $breakdown[] = array(
            'jenis_ruang' => $detail->jenis_ruang,
            'jumlah' => (int)$detail->jumlah
        );
    }

    $response = array(
        'status' => 'success',
        'total_ruang' => (int)$data->jumlah_ruang,
        'breakdown_jenis' => $breakdown
    );
} else {
    $response = array(
        'status' => 'error',
        'message' => 'Gagal mengambil data: ' . mysqli_error($conn)
    );
}

echo json_encode($response);
