<!DOCTYPE html>
<html>

<head>
    <link rel="dns-prefetch" href="//unpkg.com" />
    <link rel="dns-prefetch" href="//cdn.jsdelivr.net" />
    <link rel="stylesheet" href="https://unpkg.com/tailwindcss@^1.0/dist/tailwind.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/locales/id.js"></script>


    <style>
        :root {
            --primary: #268c43;
            --primary-light: #1a6b30;
            --secondary: #005792;
            --light: #e6f6ec;
            --dark: #343a40;
            --accent: #ffc107;
        }


        [x-cloak] {
            display: none;
        }

        body {
            margin: 0;
            padding: 0;
            font-family: poppins;
        }


        .header {
            background: linear-gradient(135deg, #268c43, #38d966);
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 87, 146, 0.2);
        }

        .header h2 {
            color: white;
            font-family: 'Poppins', sans-serif;
            /* Font family sebaiknya di CSS */
            font-size: 1.75rem;
            /* Ukuran yang lebih proporsional untuk h2 (~28px) */
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-family: 'Poppins', sans-serif;
            font-weight: 300;
            letter-spacing: 1px;
            font-size: 1rem;

        }

        .footer {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            text-align: center;
            padding: 2rem 0;
            border-radius: 40px 40px 0 0;
            margin-top: 3rem;
        }

        .footer-text {
            margin-bottom: 1rem;
            font-weight: 300;
        }

        .social-icons {
            margin-bottom: 1rem;
        }

        .social-icons a {
            color: white;
            margin: 0 0.5rem;
            font-size: 1.2rem;
            transition: all 0.3s;
        }

        .social-icons a:hover {
            transform: translateY(-3px);
            color: var(--accent);
        }

        @media (max-width: 768px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 25px 25px;
            }

            .header h2 {
                font-size: 2rem;
            }

            .main-card {
                border-radius: 15px;
            }

            .step-item {
                flex-direction: column;
            }

            .step-number {
                margin-bottom: 1rem;
                margin-right: 0;
            }

            .download-section,
            .info-box {
                padding: 1.2rem;
            }
        }

        /* Pastikan font Poppins tersedia */
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    </style>
</head>

<br>
<br>
<br>

<body class="antialiased sans-serif bg-gray-50">
    <!-- Header Section -->
    <div class="header text-center">
        <h2><?= esc($ruang['nama_ruang']); ?></h2>
        <p><?= esc($ruang['jenis_ruang']); ?></p>
    </div>

    <!-- Calendar View -->
    <div x-data="app('<?= $kode_ruang ?>')" x-init="initDate(); getBookingData()" x-cloak>
        <div class="container mx-auto px-4 py-8">
            <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                <!-- Header with refresh button -->
                <div class="flex items-center justify-between p-4 border-b">
                    <div class="flex items-center">
                        <!-- Notification element with improved visibility -->
                        <div id="refresh-notification" class="mr-3 text-sm font-medium text-green-600 hidden">
                            <span class="flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1 animate-spin" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                </svg>
                                Refreshing data...
                            </span>
                        </div>

                        <button @click="refreshBookingData()" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 transition-colors flex items-center shadow-sm" :disabled="isLoading">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" :class="{'animate-spin': isLoading}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                            </svg>
                            <span x-text="isLoading ? 'Loading...' : 'Refresh Data'"></span>
                        </button>
                    </div>
                </div>

                <!-- Last refresh indicator with improved styling -->
                <div class="px-6 py-2 text-xs text-gray-500 bg-gray-50 flex items-center" x-show="lastRefresh">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Last updated: <span class="font-medium ml-1" x-text="lastRefresh ? lastRefresh.toLocaleTimeString() : ''"></span>
                </div>

                <!-- Error message display with improved visibility -->
                <div class="px-6 py-3 text-sm text-red-700 bg-red-50 border-l-4 border-red-500" x-show="apiError">
                    <div class="flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                        <span>Error loading data: <span class="font-medium" x-text="errorMessage || 'Please try refreshing again'"></span></span>
                    </div>
                </div>

                <!-- Calendar header with improved navigation buttons -->
                <div class="flex items-center justify-between py-3 px-6 bg-gray-50">
                    <div>
                        <span x-text="MONTH_NAMES[month]" class="text-xl font-bold text-gray-800"></span>
                        <span x-text="year" class="ml-1 text-xl text-gray-600 font-normal"></span>
                    </div>
                    <div class="border rounded-lg px-1 shadow-sm" style="padding-top: 2px;">
                        <button type="button" class="leading-none rounded-lg transition ease-in-out duration-100 inline-flex cursor-pointer hover:bg-gray-200 p-1 items-center"
                            :class="{'cursor-not-allowed opacity-25': month == 0 && year == minYear}"
                            :disabled="month == 0 && year == minYear ? true : false"
                            @click="prevMonth()">
                            <svg class="h-6 w-6 text-gray-600 inline-flex leading-none" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                            </svg>
                        </button>
                        <div class="border-r inline-flex h-6"></div>
                        <button type="button" class="leading-none rounded-lg transition ease-in-out duration-100 inline-flex items-center cursor-pointer hover:bg-gray-200 p-1"
                            :class="{'cursor-not-allowed opacity-25': month == 11 && year == maxYear}"
                            :disabled="month == 11 && year == maxYear ? true : false"
                            @click="nextMonth()">
                            <svg class="h-6 w-6 text-gray-600 inline-flex leading-none" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Status Legend with smaller styling -->
                <div class="flex justify-end px-6 py-2 space-x-3 bg-gray-50 border-b">
                    <div class="flex items-center">
                        <span class="inline-block w-3 h-3 rounded-full bg-yellow-100 border border-yellow-300 mr-1"></span>
                        <span class="text-xs text-gray-600">Diproses</span>
                    </div>
                    <div class="flex items-center">
                        <span class="inline-block w-3 h-3 rounded-full bg-green-100 border border-green-300 mr-1"></span>
                        <span class="text-xs text-gray-600">Disetujui</span>
                    </div>
                    <div class="flex items-center">
                        <span class="inline-block w-3 h-3 rounded-full bg-red-100 border border-red-300 mr-1"></span>
                        <span class="text-xs text-gray-600">Ditolak</span>
                    </div>
                </div>

                <!-- Calendar Grid -->
                <div class="-mx-1 -mb-1">
                    <!-- Day headers with improved styling -->
                    <div class="flex flex-wrap bg-gray-100">
                        <template x-for="(day, index) in DAYS" :key="index">
                            <div style="width: 14.26%" class="px-2 py-3">
                                <div x-text="day" class="text-gray-700 text-sm uppercase tracking-wide font-bold text-center"></div>
                            </div>
                        </template>
                    </div>

                    <!-- Calendar days -->
                    <div class="flex flex-wrap border-t border-l">
                        <template x-for="(blankday, i) in blankdays" :key="'blank'+i">
                            <div style="width: 14.28%; height: 120px" class="text-center border-r border-b px-4 pt-2 bg-gray-50"></div>
                        </template>
                        <template x-for="(date, dateIndex) in no_of_days" :key="dateIndex">
                            <div style="width: 14.28%; height: 120px" class="px-4 pt-2 border-r border-b relative hover:bg-gray-50 transition-colors">
                                <div
                                    x-text="date"
                                    class="inline-flex w-7 h-7 items-center justify-center cursor-pointer text-center leading-none rounded-full transition ease-in-out duration-100"
                                    :class="{'bg-blue-600 text-white font-bold': isToday(date) == true, 'text-gray-700 hover:bg-blue-200': isToday(date) == false }">
                                </div>
                                <div style="height: 80px;" class="overflow-y-auto mt-1 scrollbar-thin">
                                    <!-- Loader indicator -->
                                    <div x-show="isLoading" class="text-center py-2 text-gray-500 text-xs">
                                        <svg class="animate-spin h-4 w-4 mx-auto" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                        </svg>
                                    </div>

                                    <!-- Error indicator -->
                                    <div x-show="apiError" class="text-xs text-red-500 flex items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3 mr-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        </svg>
                                        Error
                                    </div>

                                    <!-- Booking items with improved styling -->
                                    <template x-for="(booking, idx) in getBookingsForDate(date)" :key="idx">
                                        <div
                                            class="px-2 py-1 rounded-md mt-1 overflow-hidden border text-xs cursor-pointer hover:opacity-90 transition-opacity duration-150 shadow-sm"
                                            :class="{
                                            'border-yellow-300 text-yellow-800 bg-yellow-50': booking.status === 'Diproses',
                                            'border-green-300 text-green-800 bg-green-50': booking.status === 'Disetujui',
                                            'border-red-300 text-red-800 bg-red-50': booking.status === 'Ditolak'
                                        }"
                                            @click="showBookingDetails(booking)">
                                            <p x-text="booking.nama_kegiatan" class="font-bold truncate leading-tight"></p>
                                            <p x-text="booking.nama_organisasi" class="truncate leading-tight"></p>
                                        </div>
                                    </template>
                                </div>
                            </div>
                        </template>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for booking details with centered positioning -->
        <div
            x-show="showModal"
            class="fixed inset-0 z-50 overflow-auto bg-black bg-opacity-50 flex items-center justify-center"
            x-transition:enter="transition ease duration-300"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease duration-300"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @click.away="showModal = false"
            style="backdrop-filter: blur(3px); font-family: 'Poppins', sans-serif;">
            <div
                class="bg-white rounded-lg shadow-lg max-w-md w-full mx-4 overflow-hidden"
                x-transition:enter="transition ease duration-300"
                x-transition:enter-start="opacity-0 transform"
                x-transition:enter-end="opacity-100 transform"
                x-transition:leave="transition ease duration-300"
                x-transition:leave-start="opacity-100 transform"
                x-transition:leave-end="opacity-0 transform"
                @click.stop>

                <!-- Modal Header with Status (simplified) -->
                <div
                    class="px-6 py-3"
                    :class="{
                    'bg-yellow-50 border-b border-yellow-200': selectedBooking.status === 'Diproses',
                    'bg-green-50 border-b border-green-200': selectedBooking.status === 'Disetujui',
                    'bg-red-50 border-b border-red-200': selectedBooking.status === 'Ditolak'
                }">
                    <div class="flex justify-between items-center">
                        <h3 class="text-base font-bold text-gray-800" x-text="selectedBooking.nama_kegiatan"></h3>
                        <div class="flex items-center">
                            <span
                                class="text-xs px-2 py-1 rounded-md"
                                :class="{
                                'bg-yellow-100 text-yellow-800 border border-yellow-200': selectedBooking.status === 'Diproses',
                                'bg-green-100 text-green-800 border border-green-200': selectedBooking.status === 'Disetujui',
                                'bg-red-100 text-red-800 border border-red-200': selectedBooking.status === 'Ditolak'
                            }"
                                x-text="selectedBooking.status"></span>
                            <button @click="showModal = false" class="ml-2 text-gray-500 hover:text-gray-700 hover:bg-gray-100 rounded p-1 transition-colors">
                                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M6 18L18 6M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Modal Body with simpler layout -->
                <div class="px-6 py-4 space-y-3">
                    <!-- Organisasi -->
                    <div class="flex flex-col">
                        <label class="text-xs font-semibold text-gray-500 mb-1">Organisasi</label>
                        <p class="text-gray-800" x-text="selectedBooking.nama_organisasi"></p>
                    </div>

                    <!-- Nama Ruang -->
                    <div class="flex flex-col">
                        <label class="text-xs font-semibold text-gray-500 mb-1">Nama Ruang</label>
                        <p class="text-gray-800" x-text="selectedBooking.nama_ruang || '-'"></p>
                    </div>

                    <!-- Periode peminjaman with simpler layout -->
                    <div class="flex flex-col">
                        <label class="text-xs font-semibold text-gray-500 mb-1">Periode Peminjaman</label>
                        <div class="flex flex-col sm:flex-row sm:space-x-4">
                            <div class="mb-1 sm:mb-0">
                                <p class="text-xs text-gray-500">Mulai</p>
                                <p class="text-gray-800" x-text="formatDate(selectedBooking.tanggal_mulai)"></p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Selesai</p>
                                <p class="text-gray-800" x-text="formatDate(selectedBooking.tanggal_selesai)"></p>
                            </div>
                        </div>
                    </div>

                    <!-- Waktu with simpler layout -->
                    <div class="flex flex-col">
                        <label class="text-xs font-semibold text-gray-500 mb-1">Waktu</label>
                        <div class="flex flex-col sm:flex-row sm:space-x-4">
                            <div class="mb-1 sm:mb-0">
                                <p class="text-xs text-gray-500">Jam Mulai</p>
                                <p class="text-gray-800" x-text="formatTime(selectedBooking.waktu_mulai)"></p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500">Jam Selesai</p>
                                <p class="text-gray-800" x-text="formatTime(selectedBooking.waktu_selesai)"></p>
                            </div>
                        </div>
                    </div>

                    <!-- Catatan tambahan with simpler styling -->
                    <div x-show="selectedBooking.catatan" class="flex flex-col">
                        <label class="text-xs font-semibold text-gray-500 mb-1">Catatan</label>
                        <p class="text-gray-800 whitespace-pre-wrap" x-text="selectedBooking.catatan"></p>
                    </div>
                </div>

                <!-- Modal Footer with simplified styling -->
                <div class="bg-gray-50 px-6 py-2 text-xs text-gray-500 border-t">
                    <div class="flex justify-between">
                        <span>
                            ID: <span x-text="selectedBooking.id || 'N/A'"></span>
                        </span>

                        <span>
                            Dibuat: <span x-text="formatDateTime(selectedBooking.created_at)"></span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Frontend JavaScript code with enhanced debugging
        const MONTH_NAMES = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
        const DAYS = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];

        // Store calendar as a global variable to access it for refreshing
        let globalCalendar;

        // Debug function to inspect calendar events
        function inspectCalendarEvents() {
            if (globalCalendar) {
                const events = globalCalendar.getEvents();
                console.log(`Current calendar has ${events.length} events:`);
                events.forEach(event => {
                    console.log(`ID: ${event.id}, Title: ${event.title}, Status: ${event.extendedProps.status}, Class: ${event.classNames}`);
                });
            }
        }

        // Improved helper function for status classes
        function getStatusClass(status) {
            // Convert to string and trim to handle any unexpected input
            const processedStatus = String(status || '').trim();
            let className = '';

            switch (processedStatus.toLowerCase()) {
                case 'diproses':
                case 'pending':
                case 'process':
                    className = 'bg-yellow-100 border-yellow-300 text-yellow-800';
                    break;
                case 'disetujui':
                case 'approved':
                case 'accept':
                    className = 'bg-green-100 border-green-300 text-green-800';
                    break;
                case 'ditolak':
                case 'rejected':
                case 'deny':
                    className = 'bg-red-100 border-red-300 text-red-800';
                    break;
                default:
                    // Log unexpected status values to help with debugging
                    console.warn(`Unknown status value encountered: "${status}"`);
                    className = 'bg-gray-100 border-gray-300 text-gray-800';
            }

            console.log(`Status class for "${status}": ${className}`);
            return className;
        }

        // Add this to your admin panel code where status changes are saved
        function notifyStatusChange(bookingId, newStatus) {
            // Force a timestamp to break potential caching
            const timestamp = new Date().getTime();

            // Dispatch global event
            document.dispatchEvent(new CustomEvent('statusUpdated', {
                detail: {
                    bookingId,
                    newStatus,
                    source: 'adminPanel',
                    timestamp
                }
            }));

            // If your Alpine component is accessible globally
            if (window.alpineInstance && typeof window.alpineInstance.statusUpdated === 'function') {
                window.alpineInstance.statusUpdated(bookingId, newStatus);
            }

            // Additional backup - force refresh calendar directly
            if (typeof refreshCalendar === 'function') {
                refreshCalendar();
            }
        }

        // Function to manually update event styling based on status (IMPROVED)
        function updateEventStyles() {
            if (globalCalendar) {
                const events = globalCalendar.getEvents();
                console.log(`Updating styles for ${events.length} events...`);

                events.forEach(event => {
                    // Get the current status from extendedProps
                    const status = event.extendedProps.status;
                    console.log(`Updating event ${event.id} (${event.title}) with status "${status}"`);

                    if (!status) {
                        console.warn(`Event ${event.id} has no status!`);
                        // Try to fetch the status from the server
                        fetch(`/api/peminjaman/detail/${event.id}?_=${new Date().getTime()}`)
                            .then(response => response.json())
                            .then(data => {
                                if (data.status === 'success' && data.data && data.data.status) {
                                    console.log(`Retrieved status for event ${event.id}: ${data.data.status}`);

                                    // Update event with fetched status
                                    event.setExtendedProp('status', data.data.status);

                                    // Apply styles based on the fetched status
                                    event.setProp('classNames', []);
                                    const statusClasses = getStatusClass(data.data.status).split(' ');
                                    statusClasses.forEach(cls => {
                                        if (cls) event.addClassName(cls);
                                    });
                                }
                            })
                            .catch(error => {
                                console.error(`Failed to fetch status for event ${event.id}:`, error);
                            });
                        return;
                    }

                    // Get the appropriate class for this status
                    const statusClasses = getStatusClass(status);

                    // Reset all classes first
                    event.setProp('classNames', []);

                    // Apply the new classes
                    const newClasses = statusClasses.split(' ');
                    newClasses.forEach(cls => {
                        if (cls) {
                            event.addClassName(cls);
                        }
                    });

                    console.log(`Updated event ${event.id} classes to: ${event.classNames.join(', ')}`);
                });

                // Force render calendar
                globalCalendar.render();
            }
        }

        function forceCalendarRefresh() {
            if (globalCalendar) {
                console.log('Force refreshing calendar...');

                // Remove all existing events
                globalCalendar.getEvents().forEach(event => event.remove());

                // Refetch events from server
                globalCalendar.refetchEvents();

                // Make sure styles are applied correctly after events load
                setTimeout(() => {
                    updateEventStyles();
                    inspectCalendarEvents();
                    globalCalendar.render();
                }, 500);
            }
        }

        // Improve the existing event listener for status updates
        document.addEventListener('statusUpdated', function(e) {
            console.log('Status update event received', e.detail);

            // Force a complete calendar refresh
            forceCalendarRefresh();

            // If we have the specific ID that was updated, update it directly too
            if (e.detail.bookingId && e.detail.newStatus && globalCalendar) {
                const event = globalCalendar.getEventById(e.detail.bookingId);
                if (event) {
                    console.log(`Directly updating event ${e.detail.bookingId} to status ${e.detail.newStatus}`);

                    // Update the status in extended props
                    event.setExtendedProp('status', e.detail.newStatus);

                    // Reset all classes
                    event.setProp('classNames', []);

                    // Apply new classes based on status
                    const statusClasses = getStatusClass(e.detail.newStatus).split(' ');
                    statusClasses.forEach(cls => {
                        if (cls) {
                            event.addClassName(cls);
                        }
                    });
                }
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var selectRoom = document.getElementById('kode_ruang');

            // Only initialize the calendar if the element exists
            if (calendarEl) {
                console.log('Initializing calendar...');

                var calendar = new FullCalendar.Calendar(calendarEl, {
                    locale: 'id',
                    initialView: 'dayGridMonth',
                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,timeGridWeek,listWeek'
                    },
                    events: function(fetchInfo, successCallback, failureCallback) {
                        var kodeRuang = selectRoom ? selectRoom.value : '<?= $kode_ruang ?>';
                        var year = fetchInfo.start.getFullYear();
                        var month = ('0' + (fetchInfo.start.getMonth() + 1)).slice(-2); // Format bulan 2 digit

                        console.log(`Fetching events for room ${kodeRuang}, ${year}-${month}`);

                        // Add timestamp to prevent caching
                        const timestamp = new Date().getTime();
                        const url = `/api/peminjaman/${kodeRuang}/${year}/${month}?_=${timestamp}`;

                        console.log(`API URL: ${url}`);

                        fetch(url, {
                                method: 'GET',
                                headers: {
                                    'Accept': 'application/json',
                                    'Cache-Control': 'no-cache, no-store, must-revalidate',
                                    'Pragma': 'no-cache',
                                    'Expires': '0'
                                },
                                credentials: 'same-origin'
                            })
                            .then(response => {
                                if (!response.ok) {
                                    console.error(`HTTP error! status: ${response.status}`);
                                    throw new Error(`HTTP error! status: ${response.status}`);
                                }
                                return response.json();
                            })
                            .then(data => {
                                console.log('API Response:', data);

                                // Handle the response format correctly
                                let events = [];

                                // Check if the response has the expected structure
                                if (data.status === 'success' && Array.isArray(data.data)) {
                                    console.log(`Processing ${data.data.length} bookings from API`);

                                    // Transform the data into the format FullCalendar expects
                                    // Tambahkan di bagian fetch events
                                    events = data.data.map(booking => {
                                        // Pastikan status tidak pernah undefined
                                        const status = booking.status || 'pending';

                                        return {
                                            id: booking.id_peminjaman,
                                            title: booking.nama_kegiatan,
                                            start: booking.tanggal_mulai,
                                            end: booking.tanggal_selesai,
                                            extendedProps: {
                                                organisasi: booking.nama_organisasi,
                                                status: status, // Gunakan status yang sudah dipastikan
                                                waktu_mulai: booking.waktu_mulai,
                                                waktu_selesai: booking.waktu_selesai,
                                                catatan: booking.catatan,
                                                created_at: booking.created_at
                                            },
                                            classNames: getStatusClass(status).split(' ') // Gunakan array class
                                        };
                                    });

                                } else if (Array.isArray(data)) {
                                    console.log(`Processing ${data.length} bookings from direct array`);

                                    // Handle case where the API returns direct array
                                    events = data.map(booking => {
                                        console.log(`Processing direct booking: ID=${booking.id_peminjaman}, Status=${booking.status}`);

                                        // Ensure status is never undefined
                                        const status = booking.status || 'pending';

                                        const event = {
                                            id: booking.id_peminjaman,
                                            title: booking.nama_kegiatan,
                                            start: booking.tanggal_mulai,
                                            end: booking.tanggal_selesai,
                                            extendedProps: {
                                                organisasi: booking.nama_organisasi,
                                                status: status,
                                                waktu_mulai: booking.waktu_mulai,
                                                waktu_selesai: booking.waktu_selesai,
                                                catatan: booking.catatan,
                                                created_at: booking.created_at
                                            },
                                            // Add class based on status
                                            className: getStatusClass(status)
                                        };

                                        console.log(`Created event: ID=${event.id}, Class=${event.className}`);
                                        return event;
                                    });
                                }

                                console.log(`Returning ${events.length} events to calendar`);
                                successCallback(events);

                                // PERBAIKAN: Menghapus setTimeout dan langsung memanggil updateEventStyles
                                updateEventStyles();
                                inspectCalendarEvents();
                            })
                            .catch(error => {
                                console.error('Error loading events:', error);
                                failureCallback(error);
                            });
                    },
                    eventClick: function(info) {
                        console.log('Event clicked:', info.event);

                        // Get the Alpine instance
                        const alpine = window.alpineInstance;

                        if (alpine && typeof alpine.showBookingDetails === 'function') {
                            // Get the event ID
                            const eventId = info.event.id;

                            console.log(`Showing details for event ID: ${eventId}, Status: ${info.event.extendedProps.status}`);

                            // Include waktu_mulai and waktu_selesai from the event's extendedProps
                            alpine.showBookingDetails({
                                id: info.event.id,
                                nama_kegiatan: info.event.title,
                                nama_organisasi: info.event.extendedProps.organisasi,
                                status: info.event.extendedProps.status,
                                tanggal_mulai: info.event.start,
                                tanggal_selesai: info.event.end,
                                waktu_mulai: info.event.extendedProps.waktu_mulai,
                                waktu_selesai: info.event.extendedProps.waktu_selesai,
                                catatan: info.event.extendedProps.catatan,
                                created_at: info.event.extendedProps.created_at
                            });

                            // Fetch the complete booking details from the server for good measure
                            fetch(`/api/peminjaman/detail/${eventId}?_=${new Date().getTime()}`)
                                .then(response => response.json())
                                .then(data => {
                                    console.log('Fetched detailed data:', data);
                                    if (data.status === 'success' && data.data) {
                                        alpine.showBookingDetails(data.data);
                                    }
                                })
                                .catch(error => {
                                    console.error('Error fetching booking details:', error);
                                });
                        } else {
                            // Fallback to simple alert
                            alert('Detail Peminjaman:\n' + info.event.title);
                        }
                    },

                    eventDidMount: function(info) {
                        // Pastikan status selalu ada
                        const status = info.event.extendedProps.status || 'pending';

                        // Reset class dulu
                        info.event.setProp('classNames', []);

                        // Terapkan class status dengan benar
                        const statusClasses = getStatusClass(status).split(' ');
                        statusClasses.forEach(cls => {
                            if (cls) info.event.addClassName(cls);
                        });

                        // Tambahkan tooltip untuk memastikan data terlihat
                        const tooltip = new Tooltip(info.el, {
                            title: `${info.event.title} (${status})`,
                            placement: 'top',
                            trigger: 'hover',
                            container: 'body'
                        });
                    },

                    // PERBAIKAN: Mengubah eventsSet handler
                    eventsSet: function(events) {
                        console.log('Events have been set or updated, ensuring styles are applied...');
                        // Langsung update style tanpa setTimeout
                        updateEventStyles();
                    }
                });

                calendar.render();

                // Store calendar in global variable for access from other functions
                globalCalendar = calendar;

                console.log('Calendar initialized and rendered');

                // Event listener untuk dropdown perubahan ruangan
                if (selectRoom) {
                    selectRoom.addEventListener('change', function() {
                        console.log('Room selection changed, refreshing events...');
                        calendar.refetchEvents();
                    });
                }

                // PERBAIKAN: Menambahkan listener untuk status update yang lebih agresif
                document.addEventListener('statusUpdated', function(e) {
                    console.log('Status update event received', e.detail);

                    // PERBAIKAN: Perbarui kalender secara lebih agresif
                    console.log('Refreshing calendar after status update...');

                    // Hapus semua event yang ada di kalender terlebih dahulu
                    calendar.getEvents().forEach(event => event.remove());

                    // Muat ulang semua event
                    calendar.refetchEvents();

                    // Update styles dan render ulang kalender
                    setTimeout(() => {
                        updateEventStyles();
                        calendar.render();
                    }, 300);
                });
            }
        });

        // PERBAIKAN: Function untuk refresh kalender dengan cara yang lebih agresif
        function refreshCalendar() {
            if (globalCalendar) {
                console.log('Manually refreshing calendar completely...');

                // Hapus semua event yang ada
                globalCalendar.getEvents().forEach(event => event.remove());

                // Muat ulang semua event
                globalCalendar.refetchEvents();

                // Pastikan styles diupdate dan kalendar di-render ulang
                setTimeout(() => {
                    updateEventStyles();
                    globalCalendar.render();
                }, 300);
            }
        }

        function app(kode_ruang) {
            return {
                bookings: [],
                year: new Date().getFullYear(),
                month: new Date().getMonth(),
                isLoading: false,
                apiError: false,
                errorMessage: '',
                selectedBooking: null,
                kode_ruang: kode_ruang,
                lastRefresh: null,
                blankdays: [],
                no_of_days: [],
                refreshTimeout: null,
                showModal: false,

                init() {
                    // Make this Alpine component accessible globally
                    window.alpineInstance = this;
                    console.log('Alpine app initialized with room:', this.kode_ruang);
                    this.initDate();
                    this.getBookingData();
                },

                async getBookingData() {
                    console.log('Getting booking data...');
                    this.isLoading = true;
                    this.apiError = false;
                    this.errorMessage = '';

                    const oldBookings = this.bookings.length > 0 ? [...this.bookings] : [];
                    this.bookings = []; // Reset data lama

                    try {
                        const formattedMonth = String(this.month + 1).padStart(2, '0');
                        const timestamp = new Date().getTime();
                        const url = `/api/peminjaman/${this.kode_ruang}/${this.year}/${formattedMonth}?_=${timestamp}`;
                        console.log("Fetching data from:", url);

                        const response = await fetch(url, {
                            method: 'GET',
                            headers: {
                                'Accept': 'application/json',
                                'Cache-Control': 'no-cache, no-store, must-revalidate',
                                'Pragma': 'no-cache',
                                'Expires': '0'
                            },
                            credentials: 'same-origin'
                        });

                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }

                        const data = await response.json();
                        console.log('Booking data response:', data);

                        if (data.status === 'success' && Array.isArray(data.data)) {
                            console.log(`Received ${data.data.length} bookings`);
                            this.bookings = data.data;
                        } else if (Array.isArray(data)) {
                            console.log(`Received ${data.length} bookings in direct array`);
                            this.bookings = data.filter(item => item.kode_ruang === this.kode_ruang);
                        } else {
                            throw new Error("Unexpected data format received");
                        }

                        this.lastRefresh = new Date();
                        console.log(`Updated bookings array with ${this.bookings.length} items`);

                        // Notify that booking data has been updated
                        document.dispatchEvent(new CustomEvent('statusUpdated', {
                            detail: {
                                source: 'getBookingData',
                                count: this.bookings.length
                            }
                        }));

                        // PERBAIKAN: Gunakan refreshCalendar baru
                        refreshCalendar();

                    } catch (error) {
                        console.error('Error fetching booking data:', error);
                        this.apiError = true;
                        this.errorMessage = error.message;
                        if (oldBookings.length > 0) {
                            console.log('Falling back to previous bookings data');
                            this.bookings = oldBookings;
                        }
                    } finally {
                        this.isLoading = false;
                    }
                },

                getBookingsForDate(date) {
                    if (!Array.isArray(this.bookings) || this.bookings.length === 0) return [];

                    try {
                        const currentDate = new Date(this.year, this.month, date);
                        const currentDateStr = `${currentDate.getFullYear()}-${String(currentDate.getMonth() + 1).padStart(2, '0')}-${String(currentDate.getDate()).padStart(2, '0')}`;

                        return this.bookings.filter(booking => {
                            const startDate = booking.tanggal_mulai?.split('T')[0];
                            const endDate = booking.tanggal_selesai?.split('T')[0];

                            if (!startDate || !endDate) {
                                console.log(`Skipping booking with invalid dates: ${JSON.stringify(booking)}`);
                                return false;
                            }

                            return currentDateStr >= startDate && currentDateStr <= endDate;
                        });
                    } catch (error) {
                        console.error("Error in getBookingsForDate:", error);
                        return [];
                    }
                },

                initDate() {
                    this.getNoOfDays();
                },

                getNoOfDays() {
                    const lastDay = new Date(this.year, this.month + 1, 0).getDate();
                    const firstDay = new Date(this.year, this.month, 1).getDay();

                    this.blankdays = Array.from({
                        length: firstDay
                    }, (_, i) => i);
                    this.no_of_days = Array.from({
                        length: lastDay
                    }, (_, i) => i + 1);
                },

                nextMonth() {
                    if (this.month === 11) {
                        this.month = 0;
                        this.year++;
                    } else {
                        this.month++;
                    }
                    this.initDate();
                    this.getBookingData();
                },

                prevMonth() {
                    if (this.month === 0) {
                        this.month = 11;
                        this.year--;
                    } else {
                        this.month--;
                    }
                    this.initDate();
                    this.getBookingData();
                },

                isToday(date) {
                    const today = new Date();
                    const d = new Date(this.year, this.month, date);
                    return today.toDateString() === d.toDateString();
                },

                showBookingDetails(booking) {
                    console.log('Showing booking details:', booking);
                    this.selectedBooking = booking;
                    this.showModal = true;
                },

                formatDate(dateString) {
                    if (!dateString) return 'Tidak tersedia';
                    try {
                        const date = new Date(dateString);
                        if (isNaN(date)) return 'Format tanggal tidak valid';

                        const day = date.getDate();
                        const month = MONTH_NAMES[date.getMonth()].substring(0, 3);
                        const year = date.getFullYear();
                        return `${day} ${month} ${year}`;
                    } catch (error) {
                        console.error('Error formatting date:', error);
                        return 'Error';
                    }
                },

                formatTime(time) {
                    if (!time) return 'Tidak tersedia';
                    const [hours, minutes] = time.split(':');
                    const hour = parseInt(hours);
                    const ampm = hour >= 12 ? 'PM' : 'AM';
                    const hour12 = hour % 12 || 12;
                    return `${hour12}:${minutes} ${ampm}`;
                },

                formatDateTime(dateTimeString) {
                    if (!dateTimeString) return 'Tidak tersedia';
                    try {
                        const date = new Date(dateTimeString);
                        if (isNaN(date)) return 'Format tanggal tidak valid';

                        const day = date.getDate();
                        const month = MONTH_NAMES[date.getMonth()].substring(0, 3);
                        const year = date.getFullYear();
                        const hours = String(date.getHours()).padStart(2, '0');
                        const minutes = String(date.getMinutes()).padStart(2, '0');

                        return `${day} ${month} ${year}, ${hours}:${minutes}`;
                    } catch (error) {
                        console.error('Error formatting datetime:', error);
                        return 'Error';
                    }
                },

                refreshBookingData() {
                    console.log("Manually refreshing booking data...");
                    this.isLoading = true;

                    if (this.refreshTimeout) {
                        clearTimeout(this.refreshTimeout);
                    }

                    const notifyElement = document.getElementById('refresh-notification');
                    if (notifyElement) {
                        notifyElement.classList.remove('hidden');
                        setTimeout(() => {
                            notifyElement.classList.add('hidden');
                        }, 3000);
                    }

                    this.refreshTimeout = setTimeout(() => {
                        this.getBookingData()
                            .then(() => {
                                console.log("Refresh completed successfully");
                                // Dispatch custom event to notify calendar
                                document.dispatchEvent(new CustomEvent('statusUpdated', {
                                    detail: {
                                        source: 'refreshBookingData',
                                        count: this.bookings.length
                                    }
                                }));
                            })
                            .catch(err => console.error("Error during refresh:", err));
                    }, 300);
                },

                // PERBAIKAN: statusUpdated yang lebih agresif
                statusUpdated(bookingId, newStatus) {
                    console.log(`Status updated for booking ${bookingId} to "${newStatus}"`);

                    // Langsung update event di kalender jika ada
                    if (globalCalendar) {
                        const event = globalCalendar.getEventById(bookingId);
                        if (event) {
                            // Update status di extendedProps
                            event.setExtendedProp('status', newStatus);

                            // Reset class terlebih dahulu
                            event.setProp('classNames', []);

                            // Tambahkan class baru sesuai status
                            const statusClasses = getStatusClass(newStatus).split(' ');
                            statusClasses.forEach(cls => {
                                if (cls) event.addClassName(cls);
                            });
                        }
                    }

                    // Tunggu sebentar lalu refresh data lengkap
                    setTimeout(() => {
                        // Refresh full data
                        this.getBookingData();

                        // Paksa kalender refresh total
                        if (globalCalendar) {
                            globalCalendar.refetchEvents();
                        }
                    }, 500);
                }
            };
        }
    </script>


    <div class="container py-5">
        <div class="row g-4">
            <!-- Left column - Room Details Card -->
            <div class="col-lg-4">
                <div class="card border-0 shadow rounded-4 overflow-hidden" style="box-shadow: 0 8px 20px rgba(0,0,0,0.1) !important; border: 1px solid rgba(38, 140, 67, 0.2) !important;">
                    <img src="<?= base_url('/' . $ruang['foto']); ?>" class="card-img-top" alt="<?= esc($ruang['nama_ruang']); ?>" style="height: 200px; object-fit: cover;">
                    <div class="card-body p-4">
                        <h5 class="card-title fw-bold mb-3" style="background: linear-gradient(135deg, #268c43, #005792); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-family: 'Poppins', sans-serif;"><?= esc($ruang['nama_ruang']); ?></h5>
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-people-fill me-2" style="color: #268c43;"></i>
                            <span><strong>Kapasitas:</strong> <?= esc($ruang['kapasitas']); ?> orang</span>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-tag-fill me-2" style="color: #268c43;"></i>
                            <span><strong>Jenis:</strong> <?= esc($ruang['jenis_ruang']); ?></span>
                        </div>
                        <div class="d-flex align-items-start">
                            <i class="bi bi-stars me-2 mt-1" style="color: #268c43;"></i>
                            <span><strong>Fasilitas:</strong> <?= esc($ruang['fasilitas']); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right column - Booking Form -->
            <div class="col-lg-8">
                <div class="card border-0 shadow rounded-4" style="box-shadow: 0 8px 20px rgba(0,0,0,0.1) !important; border: 1px solid rgba(38, 140, 67, 0.2) !important;">
                    <div class="card-body p-4">
                        <h4 class="card-title text-center fw-bold mb-4" style="background: linear-gradient(135deg, #268c43, #005792); -webkit-background-clip: text; -webkit-text-fill-color: transparent; font-family: 'Poppins', sans-serif;">Form Peminjaman Ruangan</h4>

                        <form action="<?php echo base_url('booking_tambah'); ?>" method="POST" enctype="multipart/form-data">
                            <!-- Progress indicator -->
                            <div class="position-relative mb-5">
                                <div class="progress" style="height: 3px;">
                                    <div class="progress-bar" role="progressbar" style="width: 100%; background: linear-gradient(to right, #268c43, #005792);" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                                </div>
                                <div class="d-flex justify-content-between mt-2">
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; background: linear-gradient(135deg, #268c43, #005792); color: white; margin-top: -18px; box-shadow: 0 4px 8px rgba(0, 87, 146, 0.3);">
                                            <i class="bi bi-building"></i>
                                        </div>
                                        <span class="small mt-1">Ruangan</span>
                                    </div>
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; background: linear-gradient(135deg, #268c43, #005792); color: white; margin-top: -18px; box-shadow: 0 4px 8px rgba(0, 87, 146, 0.3);">
                                            <i class="bi bi-calendar-event"></i>
                                        </div>
                                        <span class="small mt-1">Kegiatan</span>
                                    </div>
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; background: linear-gradient(135deg, #268c43, #005792); color: white; margin-top: -18px; box-shadow: 0 4px 8px rgba(0, 87, 146, 0.3);">
                                            <i class="bi bi-clock"></i>
                                        </div>
                                        <span class="small mt-1">Waktu</span>
                                    </div>
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rounded-circle d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; background: linear-gradient(135deg, #268c43, #005792); color: white; margin-top: -18px; box-shadow: 0 4px 8px rgba(0, 87, 146, 0.3);">
                                            <i class="bi bi-file-earmark"></i>
                                        </div>
                                        <span class="small mt-1">Dokumen</span>
                                    </div>
                                </div>
                            </div>

                            <!-- Hidden input -->
                            <input type="hidden" name="id_user" value="<?= session()->get('id_user'); ?>">

                            <!-- Section: Room Information -->
                            <div class="card mb-4 border-0 bg-light rounded-4" style="box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid rgba(38, 140, 67, 0.15) !important;">
                                <div class="card-header border-0 rounded-top-4" style="background: linear-gradient(135deg, #268c43, #005792);">
                                    <h6 class="mb-0 text-white fw-semibold py-2" style="font-family: 'Poppins', sans-serif;">
                                        <i class="bi bi-building me-2"></i>Informasi Ruangan
                                    </h6>
                                </div>
                                <div class="card-body p-4">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="kode_ruang" class="form-label">Kode Ruang</label>
                                            <input type="text" class="form-control" id="kode_ruang" name="kode_ruang" value="<?= esc($ruang['kode_ruang']); ?>" readonly required>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="nama_ruang" class="form-label">Nama Ruang</label>
                                            <input type="text" class="form-control" id="nama_ruang" name="nama_ruang" value="<?= esc($ruang['nama_ruang']); ?>" readonly required>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Section: Activity Information -->
                            <div class="card mb-4 border-0 bg-light rounded-4" style="box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid rgba(38, 140, 67, 0.15) !important;">
                                <div class="card-header border-0 rounded-top-4" style="background: linear-gradient(135deg, #268c43, #005792);">
                                    <h6 class="mb-0 text-white fw-semibold py-2" style="font-family: 'Poppins', sans-serif;">
                                        <i class="bi bi-calendar-event me-2"></i>Informasi Kegiatan
                                    </h6>
                                </div>
                                <div class="card-body p-4">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="nama_kegiatan" class="form-label">Nama Kegiatan</label>
                                            <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" placeholder="Masukkan nama kegiatan" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="nama_organisasi" class="form-label">Nama Organisasi</label>
                                            <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" placeholder="Masukkan nama organisasi" required>
                                        </div>
                                        <div class="col-md-12">
                                            <label for="kapasitas" class="form-label">Kapasitas Peserta</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control" id="kapasitas" name="kapasitas" placeholder="Jumlah peserta" required>
                                                <span class="input-group-text">orang</span>

                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Section: Booking Time -->
                            <div class="card mb-4 border-0 bg-light rounded-4" style="box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid rgba(38, 140, 67, 0.15) !important;">
                                <div class="card-header border-0 rounded-top-4" style="background: linear-gradient(135deg, #268c43, #005792);">
                                    <h6 class="mb-0 text-white fw-semibold py-2" style="font-family: 'Poppins', sans-serif;">
                                        <i class="bi bi-clock me-2"></i>Waktu Peminjaman
                                    </h6>
                                </div>
                                <div class="card-body p-4">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="tanggal_mulai" class="form-label">Tanggal Mulai</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-calendar"></i></span>
                                                <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="tanggal_selesai" class="form-label">Tanggal Selesai</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-calendar"></i></span>
                                                <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="waktu_mulai" class="form-label">Waktu Mulai</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-clock"></i></span>
                                                <input type="time" class="form-control" id="waktu_mulai" name="waktu_mulai" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="waktu_selesai" class="form-label">Waktu Selesai</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-clock"></i></span>
                                                <input type="time" class="form-control" id="waktu_selesai" name="waktu_selesai" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Section: Supporting Documents -->
                            <div class="card mb-4 border-0 bg-light rounded-4" style="box-shadow: 0 4px 12px rgba(0,0,0,0.05); border: 1px solid rgba(38, 140, 67, 0.15) !important;">
                                <div class="card-header border-0 rounded-top-4" style="background: linear-gradient(135deg, #268c43, #005792);">
                                    <h6 class="mb-0 text-white fw-semibold py-2" style="font-family: 'Poppins', sans-serif;">
                                        <i class="bi bi-file-earmark me-2"></i>Dokumen Pendukung
                                    </h6>
                                </div>
                                <div class="card-body p-4">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="dok_peminjaman" class="form-label">Dokumen Peminjaman (PDF)</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-file-earmark-pdf"></i></span>
                                                <input type="file" class="form-control" id="dok_peminjaman" name="dok_peminjaman" accept=".pdf" required>
                                            </div>
                                            <div class="form-text">Unggah surat permohonan peminjaman ruangan</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="dok_ktm" class="form-label">Dokumen KTM (Gambar)</label>
                                            <div class="input-group">
                                                <span class="input-group-text"><i class="bi bi-card-image"></i></span>
                                                <input type="file" class="form-control" id="dok_ktm" name="dok_ktm" accept="image/*" required>
                                            </div>
                                            <div class="form-text">Unggah foto KTM/kartu identitas</div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="status" class="form-label">Status Peminjaman</label>
                                            <select class="form-select" id="status" name="status" readonly required>
                                                <option value="Diproses">Diproses</option>
                                            </select>
                                            <div class="form-text">Status awal peminjaman</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="d-grid mt-3">
                                <button type="submit" class="btn py-2 text-white rounded-pill" style="background: linear-gradient(135deg, #268c43, #005792); font-family: 'Poppins', sans-serif; font-weight: 500; font-size: 0.9rem; box-shadow: 0 4px 10px rgba(0, 87, 146, 0.3);">
                                    <i class="bi bi-check-circle me-1"></i>Ajukan Peminjaman
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-text">© 2025 Fakultas Kesehatan UDINUS - Semua Hak Dilindungi</div>
            <div class="social-icons">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-youtube"></i></a>
            </div>
        </div>
    </footer>
</body>

</html>