<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fakultas Kesehatan UDINUS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --secondary: #005792;
            --primary: #268c43;
            --udinus-green: #268c43;
            --udinus-green-light: #38d966;
            --background: #f0f6ff;
            --card-bg: #fff;
            --card-shadow: 0 5px 25px rgba(0, 0, 0, 0.08);
            --card-radius: 15px;
            --header-shadow: 0 4px 20px rgba(0, 102, 255, 0.15);
            --btn-gradient: linear-gradient(to right, #268c43, #38d966);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--background);
            color: #333;
        }

        .header {
            background: linear-gradient(135deg, var(--udinus-green), var(--udinus-green-light));
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: var(--header-shadow);
            text-align: center;
        }

        .header h2 {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-weight: 300;
            letter-spacing: 1px;
        }

        .room-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin: 2rem 0;
        }

        .room-card {
            background-color: var(--card-bg);
            border-radius: var(--card-radius);
            box-shadow: var(--card-shadow);
            overflow: hidden;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            display: flex;
            flex-direction: column;
            border-top: 4px solid var(--udinus-green);
        }

        .room-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
        }

        .room-image {
            height: 200px;
            overflow: hidden;
        }

        .room-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }

        .room-card:hover .room-image img {
            transform: scale(1.05);
        }

        .room-details {
            padding: 1.25rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .room-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--udinus-green);
            margin-bottom: 0.75rem;
            text-align: center;
        }

        .room-info {
            font-size: 0.95rem;
            margin-bottom: 1rem;
            color: #444;
            flex-grow: 1;
        }

        .room-info strong {
            color: var(--udinus-green);
        }

        .room-info i {
            color: var(--udinus-green);
        }

        .btn-booking {
            background: var(--udinus-green);
            border: none;
            border-radius: 8px;
            padding: 0.7rem 1.5rem;
            color: white;
            font-weight: 500;
            transition: all 0.3s;
            text-align: center;
            text-decoration: none;
            display: block;
            width: 100%;
            box-shadow: 0 4px 10px rgba(38, 140, 67, 0.3);
        }

        .btn-booking:hover {
            background: linear-gradient(to right, #2ca94b, #44e072);
            box-shadow: 0 6px 15px rgba(38, 140, 67, 0.4);
            color: white;
        }

        .footer {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            text-align: center;
            padding: 2rem 0;
            border-radius: 40px 40px 0 0;
            margin-top: 3rem;
        }

        .footer-text {
            margin-bottom: 1rem;
            font-weight: 300;
        }

        .social-icons {
            margin-bottom: 1rem;
        }

        .social-icons a {
            color: white;
            margin: 0 0.5rem;
            font-size: 1.2rem;
            transition: all 0.3s;
        }

        .social-icons a:hover {
            transform: translateY(-3px);
            color: var(--accent);
        }


        @media (max-width: 992px) {
            .room-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            }
        }

        @media (max-width: 576px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 20px 20px;
            }

            .room-image {
                height: 180px;
            }
        }
    </style>

</head>

<body>
    <div class="header">
        <h2 style="font-family: poppins;">Ruangan</h2>
        <p>Fakultas Kesehatan UDINUS</p>
    </div>

    <div class="container">
        <div class="room-grid">
            <?php foreach ($ruangan as $r) : ?>
                <div class="room-card">
                    <div class="room-image">
                        <img src="<?= base_url('/' . $r['foto']); ?>" alt="<?= esc($r['nama_ruang']); ?>">
                    </div>
                    <div class="room-details">
                        <h5 class="room-title" style="font-family: poppins;"><?= esc($r['nama_ruang']); ?></h5>
                        <div class="room-info">
                            <p><strong>Kapasitas:</strong> <?= esc($r['kapasitas']); ?> orang</p>
                            <p><strong>Jenis:</strong> <?= esc($r['jenis_ruang']); ?></p>
                            <p><strong>Fasilitas:</strong> <?= esc($r['fasilitas']); ?></p>
                        </div>
                        <a href="<?= base_url('/ruangan_detail/' . $r['kode_ruang']); ?>" class="btn-booking">
                            <i class="bi bi-calendar-check me-2"></i>Booking
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-text">© 2025 Fakultas Kesehatan UDINUS - Semua Hak Dilindungi</div>
            <div class="social-icons">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-youtube"></i></a>
            </div>
        </div>
    </footer>
</body>

</html>