<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
</style>

<div class="container">
    <div class="card shadow-sm border-0">
        <div class="card-body">
            <h5 class="card-title" style="font-family: poppins;">Tambah Peminjaman</h5>
            <form action="<?php echo base_url('peminjaman_tambah'); ?>" method="POST" enctype="multipart/form-data">
                <div class="row">
                    <!-- Kolom Kiri -->
                    <div class="col-md-6">
                        <div class="form-group" style="font-family: poppins;">
                            <label for="kode_ruang">Kode Ruang</label>
                            <select class="form-control" id="kode_ruang" name="kode_ruang" required>
                                <option value="">-- Pilih Kode Ruang --</option>
                                <?php foreach ($ruang as $r) : ?>
                                    <option value="<?= $r->kode_ruang ?>" data-nama="<?= $r->nama_ruang ?>"><?= $r->kode_ruang ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="nama_ruang">Nama Ruang</label>
                            <input type="text" class="form-control" id="nama_ruang" name="nama_ruang" placeholder="Nama Ruangan" readonly required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="kapasitas">Kapasitas</label>
                            <input type="number" class="form-control" id="kapasitas" name="kapasitas" placeholder="Masukkan Kapasitas Ruangan" required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="nama_kegiatan">Nama Kegiatan</label>
                            <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" placeholder="Masukkan Nama Kegiatan" required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="nama_organisasi">Nama Organisasi</label>
                            <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" placeholder="Masukkan Nama Organisasi" required>
                        </div>
                    </div>

                    <!-- Kolom Kanan -->
                    <div class="col-md-6">
                        <div class="form-group" style="font-family: poppins;">
                            <label for="tanggal_mulai">Tanggal Mulai</label>
                            <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="waktu_mulai">Waktu Mulai</label>
                            <input type="time" class="form-control" id="waktu_mulai" name="waktu_mulai" required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="tanggal_selesai">Tanggal Selesai</label>
                            <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" required>
                        </div>

                        <div class="form-group" style="font-family: poppins;">
                            <label for="waktu_selesai">Waktu Selesai</label>
                            <input type="time" class="form-control" id="waktu_selesai" name="waktu_selesai" required>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-6">
                        <div class="form-group" style="font-family: poppins;">
                            <label for="dok_peminjaman">Dokumen Peminjaman (PDF)</label>
                            <input type="file" class="form-control" id="dok_peminjaman" name="dok_peminjaman" accept=".pdf" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group" style="font-family: poppins;">
                            <label for="dok_ktm">Dokumen KTM (Gambar)</label>
                            <input type="file" class="form-control" id="dok_ktm" name="dok_ktm" accept="image/*" required>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="form-group" style="font-family: poppins;">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status" required>
                                <option value="Diproses">Diproses</option>
                                <option value="Disetujui">Disetujui</option>
                                <option value="Ditolak">Ditolak</option>
                            </select>
                        </div>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary btn-block mt-3" style="font-family: poppins;">Submit</button>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript untuk mengisi Nama Ruang -->
<script>
    document.getElementById('kode_ruang').addEventListener('change', function() {
        let selectedOption = this.options[this.selectedIndex];
        let namaRuang = selectedOption.getAttribute('data-nama');
        document.getElementById('nama_ruang').value = namaRuang;
    });
</script>