<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">

<style>
    body {
        font-family: 'Poppins', sans-serif;
    }
</style>

<div class="container">
    <div class="card shadow-sm border-0">
        <div class="card-body" style="font-family: poppins;">
            <h5 class="card-title">Detail Peminjaman</h5>
            <form action="<?= base_url('adminpeminjaman_edit/' . $peminjaman['id_peminjaman']); ?>" method="POST" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="kode_ruang">Kode Ruang</label>
                            <input type="text" class="form-control" id="kode_ruang" name="kode_ruang" value="<?= $peminjaman['kode_ruang']; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label for="nama_ruang">Nama Ruang</label>
                            <input type="text" class="form-control" id="nama_ruang" name="nama_ruang" value="<?= $peminjaman['nama_ruang']; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label for="kapasitas">Kapasitas</label>
                            <input type="number" class="form-control" id="kapasitas" name="kapasitas" value="<?= $peminjaman['kapasitas']; ?>" readonly>
                        </div>
                        <div class="form-group">
                            <label for="nama_kegiatan">Nama Kegiatan</label>
                            <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" value="<?= $peminjaman['nama_kegiatan']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="nama_organisasi">Nama Organisasi</label>
                            <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" value="<?= $peminjaman['nama_organisasi']; ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="tanggal_mulai">Tanggal Mulai</label>
                            <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" value="<?= $peminjaman['tanggal_mulai']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="waktu_mulai">Waktu Mulai</label>
                            <input type="time" class="form-control" id="waktu_mulai" name="waktu_mulai" value="<?= $peminjaman['waktu_mulai']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="tanggal_selesai">Tanggal Selesai</label>
                            <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" value="<?= $peminjaman['tanggal_selesai']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="waktu_selesai">Waktu Selesai</label>
                            <input type="time" class="form-control" id="waktu_selesai" name="waktu_selesai" value="<?= $peminjaman['waktu_selesai']; ?>" required>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status" required>
                                <option value="Diproses" <?= ($peminjaman['status'] == 'Diproses') ? 'selected' : ''; ?>>Diproses</option>
                                <option value="Disetujui" <?= ($peminjaman['status'] == 'Disetujui') ? 'selected' : ''; ?>>Disetujui</option>
                                <option value="Ditolak" <?= ($peminjaman['status'] == 'Ditolak') ? 'selected' : ''; ?>>Ditolak</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="dok_peminjaman">Dokumen Peminjaman</label>
                            <input type="file" class="form-control" id="dok_peminjaman" name="dok_peminjaman">
                            <small>Biarkan kosong jika tidak ingin mengubah dokumen.</small>
                            <?php if (!empty($peminjaman['dok_peminjaman'])): ?>
                                <br>
                                <a href="<?= base_url('/' . $peminjaman['dok_peminjaman']); ?>" target="_blank">
                                    Lihat Dokumen
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="dok_ktm">Dokumen KTM</label>
                            <input type="file" class="form-control" id="dok_ktm" name="dok_ktm">
                            <small>Biarkan kosong jika tidak ingin mengubah dokumen.</small>
                            <?php if (!empty($peminjaman['dok_ktm'])): ?>
                                <br>
                                <a href="<?= base_url('/' . $peminjaman['dok_ktm']); ?>" target="_blank">
                                    Lihat KTM
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group mt-3" style="font-family: poppins;">
                            <label for="catatan" class="mb-2">Catatan</label>
                            <input type="text" class="form-control" id="catatan" name="catatan" value="<?= $peminjaman['catatan']; ?>">
                        </div>
                    </div>
                </div>


                <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                <a href="<?= base_url('adminpeminjaman'); ?>" class="btn btn-secondary">Batal</a>
            </form>
        </div>
    </div>
</div>


<script>
    // Add this to your existing admin page JavaScript
    document.addEventListener('DOMContentLoaded', function() {
        // Check if status was updated in previous request
        <?php if (session()->getFlashdata('statusUpdated')): ?>
            const updatedBooking = <?= json_encode(session()->getFlashdata('statusUpdated')) ?>;

            console.log('Status updated:', updatedBooking);

            // Try to notify any Alpine instances that might be on the page
            if (window.alpineInstance && typeof window.alpineInstance.statusUpdated === 'function') {
                window.alpineInstance.statusUpdated(updatedBooking.id, updatedBooking.status);
            }

            // Dispatch a global event for the calendar to pick up
            document.dispatchEvent(new CustomEvent('statusUpdated', {
                detail: {
                    bookingId: updatedBooking.id,
                    newStatus: updatedBooking.status,
                    source: 'adminEdit'
                }
            }));

            // Create a more aggressive global refresh function
            if (typeof refreshCalendar === 'function') {
                setTimeout(refreshCalendar, 500);
            }
        <?php endif; ?>
    });
</script>