<div class="container-fluid py-4" style="font-family: poppins;">
    <div class="row">
        <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-8">
                            <div class="numbers">
                                <a class="nav-link " href="<?php echo base_url('/adminuser'); ?>">
                                    <p class="text-sm mb-0 text-uppercase font-weight-bold">User</p>
                                    <h5 class="font-weight-bolder">
                                        <?= esc($totalUsers) ?>
                                    </h5>
                                </a>
                            </div>
                        </div>
                        <div class="col-4 text-end">
                            <div class="icon icon-shape bg-gradient-primary shadow-primary text-center rounded-circle">
                                <i class="ni ni-money-coins text-lg opacity-10" aria-hidden="true"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-8">
                            <div class="numbers">
                                <a class="nav-link " href="<?php echo base_url('/adminruangan'); ?>">
                                    <p class="text-sm mb-0 text-uppercase font-weight-bold">Ruangan</p>
                                    <h5 class="font-weight-bolder">
                                        <?= esc($totalRuangan) ?>
                                    </h5>
                                </a>
                            </div>
                        </div>
                        <div class="col-4 text-end">
                            <div class="icon icon-shape bg-gradient-danger shadow-danger text-center rounded-circle">
                                <i class="ni ni-world text-lg opacity-10" aria-hidden="true"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4 col-sm-6 mb-xl-0 mb-4">
            <div class="card">
                <div class="card-body p-3">
                    <div class="row">
                        <div class="col-9">
                            <div class="numbers">
                                <a class="nav-link " href="<?php echo base_url('/adminpeminjaman'); ?>">
                                    <p class="text-sm mb-0 text-uppercase font-weight-bold">Transaksi Peminjaman</p>
                                    <h5 class="font-weight-bolder">
                                        <?= esc($totalTransaksi) ?>
                                    </h5>
                                </a>
                            </div>
                        </div>
                        <div class="col-3 text-end">
                            <div class="icon icon-shape bg-gradient-success shadow-success text-center rounded-circle">
                                <i class="ni ni-paper-diploma text-lg opacity-10" aria-hidden="true"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Side-by-Side Charts -->
        <div class="row mt-4">
            <!-- Monthly Borrowing Chart -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header pb-0">
                        <h6>Peminjaman Per Bulan</h6>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="chart-container" style="height: 300px; width: 100%; padding: 20px;">
                            <canvas id="monthlyBorrowingChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top 5 Borrowed Rooms Chart -->
            <div class="col-lg-6">
                <div class="card mb-4">
                    <div class="card-header pb-0">
                        <h6>5 Ruangan Yang Sering Dipinjam</h6>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="chart-container" style="height: 300px; width: 100%; padding: 20px;">
                            <canvas id="topRoomsChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart Scripts -->
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Top Rooms Chart - Fixed field name
                var ctx = document.getElementById('topRoomsChart').getContext('2d');

                // Get data from PHP - Fixed to use nama_ruang instead of nama_ruangan
                var roomNames = <?= json_encode(array_column($topRooms, 'nama_ruang')) ?>;
                var borrowCounts = <?= json_encode(array_column($topRooms, 'jumlah_peminjaman')) ?>;

                // Fixed colors for better visual consistency
                var backgroundColors = [
                    'rgba(75, 192, 192, 0.7)',
                    'rgba(54, 162, 235, 0.7)',
                    'rgba(153, 102, 255, 0.7)',
                    'rgba(255, 159, 64, 0.7)',
                    'rgba(255, 99, 132, 0.7)'
                ];

                var borderColors = [
                    'rgba(75, 192, 192, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(255, 99, 132, 1)'
                ];

                var topRoomsChart = new Chart(ctx, {
                    type: 'bar',
                    data: {
                        labels: roomNames,
                        datasets: [{
                            label: 'Jumlah Peminjaman',
                            data: borrowCounts,
                            backgroundColor: backgroundColors,
                            borderColor: borderColors,
                            borderWidth: 1
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    precision: 0
                                }
                            }
                        },
                        plugins: {
                            legend: {
                                display: false
                            },
                            tooltip: {
                                callbacks: {
                                    label: function(context) {
                                        return context.raw + ' peminjaman';
                                    }
                                }
                            }
                        }
                    }
                });

                // Monthly Borrowing Chart - New
                var ctxMonthly = document.getElementById('monthlyBorrowingChart').getContext('2d');

                // Get data from PHP
                var months = <?= json_encode(array_column($monthlyBorrowings, 'month')) ?>;
                var counts = <?= json_encode(array_column($monthlyBorrowings, 'count')) ?>;

                // Month names in Indonesian
                var monthNames = ['Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
                ];

                // Convert month numbers to names
                var monthLabels = months.map(function(month) {
                    return monthNames[parseInt(month) - 1];
                });

                var monthlyChart = new Chart(ctxMonthly, {
                    type: 'line',
                    data: {
                        labels: monthLabels,
                        datasets: [{
                            label: 'Jumlah Peminjaman',
                            data: counts,
                            fill: false,
                            borderColor: 'rgba(54, 162, 235, 1)',
                            backgroundColor: 'rgba(54, 162, 235, 0.2)',
                            tension: 0.4,
                            borderWidth: 2,
                            pointBackgroundColor: 'rgba(54, 162, 235, 1)',
                            pointRadius: 4
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    precision: 0
                                }
                            }
                        },
                        plugins: {
                            tooltip: {
                                callbacks: {
                                    label: function(context) {
                                        return context.raw + ' peminjaman';
                                    }
                                }
                            }
                        }
                    }
                });
            });
        </script>
    </div>
    </main>
</div>