<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use App\Models\UserModel;
use App\Models\RuanganModel;
use App\Models\PeminjamanModel;


class Dashboard extends BaseController
{
    protected $UserModel;
    protected $RuanganModel;
    protected $PeminjamanModel;

      public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->RuanganModel = new RuanganModel();
        $this->PeminjamanModel = new PeminjamanModel();
    }

    public function dashboard()
    {
        if (!session()->get('logged_in') || session()->get('role') != 1) {
            return redirect()->to('/index')->with('error', 'Akses ditolak.');
        }

        $data['totalUsers'] = count($this->UserModel->findAll());
        $data['totalRuangan'] = count($this->RuanganModel->findAll());
        $data['totalTransaksi'] = count($this->PeminjamanModel->findAll());

        // Get top 5 most frequently borrowed rooms
        $db = \Config\Database::connect();
        $query = $db->query("
        SELECT nama_ruang, COUNT(*) as jumlah_peminjaman 
        FROM peminjaman
        WHERE status = 'Disetujui' 
        GROUP BY nama_ruang
        ORDER BY jumlah_peminjaman DESC
        LIMIT 5
    ");

        $data['topRooms'] = $query->getResult();

        // Get monthly borrowing statistics for current year
        $currentYear = date('Y');
        $queryMonthly = $db->query("
        SELECT MONTH(tanggal_mulai) as month, COUNT(*) as count
        FROM peminjaman
        WHERE YEAR(tanggal_mulai) = $currentYear
        GROUP BY MONTH(tanggal_mulai)
        ORDER BY month ASC
    ");

        $data['monthlyBorrowings'] = $queryMonthly->getResult();

        return view('backend/header')
            . view('backend/sidebar')
            . view('dashboard', $data)
            . view('backend/footer');
    }


    public function adminuser()
    {
        
        $data['users'] = $this->UserModel->findAll();

        return view('backend/header')
        . view('backend/sidebar')
        . view('datauser',$data)
            . view('backend/footer');
    }

    public function adminuser_tambah()
    {
        return view('backend/header')
        . view('backend/sidebar')
        . view('datauser_tambah')
            . view('backend/footer');
    }

    public function user_tambah()
    {
        $this->UserModel->save([
            'nama_user'  => $this->request->getPost('nama_user'),
            'nomerinduk' => $this->request->getPost('nomerinduk'),
            'no_hp'      => $this->request->getPost('no_hp'),
            'email'      => $this->request->getPost('email'),
            'password'   => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'role'       => $this->request->getPost('role'),
        ]);

        return redirect()->to('/adminuser')->with('success', 'User berhasil ditambahkan');
    }

    public function adminuser_detail($id_user)
    {
        $user = $this->UserModel->find($id_user);

        if (!$user) {
            return redirect()->to('/adminuser')->with('error', 'User tidak ditemukan');
        }

        return view('backend/header')
        . view('backend/sidebar')
        . view('datauser_detail', ['user' => $user]) // Kirim data user ke view
            . view('backend/footer');
    }
    public function adminuser_edit($id_user)
    {
        $id_user = $this->request->getPost('id_user');

        // Validasi apakah user ada
        $user = $this->UserModel->find($id_user);
        if (!$user) {
            return redirect()->to('/adminuser')->with('error', 'User tidak ditemukan');
        }

        // Ambil data yang akan diperbarui
        $data = [
                'nama_user'  => $this->request->getPost('nama_user'),
                'nomerinduk' => $this->request->getPost('nomerinduk'),
                'no_hp'      => $this->request->getPost('no_hp'),
                'email'      => $this->request->getPost('email'),
                'role'       => $this->request->getPost('role'),
            ];

        // Update data user
        $this->UserModel->update($id_user, $data);

        return redirect()->to('/adminuser')->with('success', 'Data user berhasil diperbarui');
    }

    public function adminuser_delete($id_user)
    {
        // Cek apakah user dengan ID yang diberikan ada
        $user = $this->UserModel->find($id_user);

        if (!$user) {
            return redirect()->to('/adminuser')->with('error', 'User tidak ditemukan');
        }

        // Hapus user dari database
        $this->UserModel->delete($id_user);

        return redirect()->to('/adminuser')->with('success', 'User berhasil dihapus');
    }


    public function adminruangan()
    {
        $data['ruangan'] = $this->RuanganModel->findAll(); // Ambil semua data ruangan

        return view('backend/header')
        . view('backend/sidebar')
        . view('dataruang', $data) // Kirim data ruangan ke view
            . view('backend/footer');
    }

    public function adminruangan_tambah()
    {
        return view('backend/header')
        . view('backend/sidebar')
        . view('dataruang_tambah')
        . view('backend/footer');
    }

    public function ruangan_tambah()
    {
        $foto = $this->request->getFile('foto'); // Ambil file foto

        if ($foto->isValid() && !$foto->hasMoved()) {
            $namaFoto = $foto->getRandomName(); // Buat nama file acak

            // Pastikan folder penyimpanan ada
            $path = FCPATH . 'assets/ruangan';
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }

            // Pindahkan file ke folder public/assets/ruangan
            $foto->move($path, $namaFoto);

            // Simpan nama file ke database tanpa 'public/' agar bisa diakses dengan base_url()
            $this->RuanganModel->insert([
                'kode_ruang'  => $this->request->getPost('kode_ruang'), // Sebagai primary key
                'nama_ruang'  => $this->request->getPost('nama_ruang'),
                'kapasitas'   => $this->request->getPost('kapasitas'),
                'jenis_ruang' => $this->request->getPost('jenis_ruang'),
                'fasilitas'   => $this->request->getPost('fasilitas'),
                'foto'        => 'assets/ruangan/' . $namaFoto, // Simpan path relatif ke folder public
            ]);

            return redirect()->to('/adminruangan')->with('success', 'Ruangan berhasil ditambahkan');
        } else {
            return redirect()->back()->withInput()->with('error', 'Gagal mengupload foto: ' . $foto->getError());
        }
    }

    public function adminruangan_detail($kode_ruang)
    {
        $ruangan = $this->RuanganModel->find($kode_ruang); // Cari berdasarkan kode_ruang
        if (!$ruangan) {
            return redirect()->to('/adminruangan')->with('error', 'Ruangan tidak ditemukan');
        }

        return view('backend/header')
        . view('backend/sidebar')
        . view('dataruang_detail', ['ruangan' => $ruangan]) // Kirim data ruangan ke view
        . view('backend/footer');
    }

    public function adminruangan_edit($kode_ruang)
    {
        $ruangan = $this->RuanganModel->find($kode_ruang); // Cari berdasarkan kode_ruang
        if (!$ruangan) {
            return redirect()->to('/adminruangan')->with('error', 'Ruangan tidak ditemukan');
        }

        // Cek apakah ada file foto baru yang diupload
        $foto = $this->request->getFile('foto');
        if ($foto && $foto->isValid()) {
            $namaFoto = $foto->getRandomName(); // Buat nama baru
            $foto->move('assets/ruangan', $namaFoto); // Simpan foto baru
        } else {
            $namaFoto = $ruangan['foto']; // Gunakan foto lama jika tidak ada perubahan
        }

        $this->RuanganModel->update($kode_ruang, [
            'nama_ruang' => $this->request->getPost('nama_ruang'),
            'kapasitas' => $this->request->getPost('kapasitas'),
            'jenis_ruang' => $this->request->getPost('jenis_ruang'),
            'fasilitas' => $this->request->getPost('fasilitas'),
            'foto'        => 'assets/ruangan/' . $namaFoto, // Simpan path relatif ke folder public
        ]);
        return redirect()->to('/adminruangan')->with('success', 'Data ruangan berhasil diperbarui');
    }

    public function adminruangan_delete($kode_ruang)
    {
        $ruangan = $this->RuanganModel->find($kode_ruang);

        if (!$ruangan) {
            return redirect()->to('/adminruangan')->with('error', 'Ruangan tidak ditemukan');
        }

        $this->RuanganModel->delete($kode_ruang); // Hapus berdasarkan kode_ruang

        return redirect()->to('/adminruangan')->with('success', 'Ruangan berhasil dihapus');
    }


    public function adminpeminjaman()
    {
        $data['peminjaman'] = $this->PeminjamanModel->orderBy('tanggal_mulai', 'DESC')->findAll(); // Urutkan berdasarkan tanggal mulai (terbaru dulu)

        return view('backend/header')
        . view('backend/sidebar')
        . view('datapeminjaman', $data)
            . view('backend/footer');
    }


    public function adminpeminjaman_tambah()
    {
        $data['ruang'] = $this->RuanganModel->get()->getResult(); // Ambil data ruang dari tabel 'ruang'

        return view('backend/header')
        . view('backend/sidebar')
        . view('datapeminjaman_tambah', $data) // Kirim data ke view
        . view('backend/footer');
    }


    public function peminjaman_tambah()
    {
        $validationRules = [
            'dok_peminjaman' => 'uploaded[dok_peminjaman]|mime_in[dok_peminjaman,application/pdf]|max_size[dok_peminjaman,2048]',
            'dok_ktm' => 'uploaded[dok_ktm]|mime_in[dok_ktm,image/png,image/jpg,image/jpeg]|max_size[dok_ktm,2048]'
        ];

        if (!$this->validate($validationRules)) {
            return redirect()->back()->withInput()->with('error', 'Format file tidak sesuai atau ukuran terlalu besar!');
        }

        $dokPeminjaman = $this->request->getFile('dok_peminjaman');
        $dokKTM = $this->request->getFile('dok_ktm');

        // Pastikan folder penyimpanan ada
        if (!is_dir(FCPATH . 'assets/dokumen')) {
            mkdir(FCPATH . 'assets/dokumen', 0777, true);
        }
        if (!is_dir(FCPATH . 'assets/ktm')) {
            mkdir(FCPATH . 'assets/ktm', 0777, true);
        }

        // Upload dok_peminjaman
        if ($dokPeminjaman->isValid() && !$dokPeminjaman->hasMoved()) {
            $dokPeminjamanName = $dokPeminjaman->getRandomName();
            $dokPeminjaman->move(FCPATH . 'assets/dokumen', $dokPeminjamanName);
        } else {
            return redirect()->back()->with('error', 'Gagal mengupload dokumen peminjaman.');
        }

        // Upload dok_ktm
        if ($dokKTM->isValid() && !$dokKTM->hasMoved()) {
            $dokKTMName = $dokKTM->getRandomName();
            $dokKTM->move(FCPATH . 'assets/ktm', $dokKTMName);
        } else {
            return redirect()->back()->with('error', 'Gagal mengupload dokumen KTM.');
        }

        // Simpan ke database
        $this->PeminjamanModel->insert([
            'id_user' => session()->get('id_user'), // Ambil dari session
            'kode_ruang' => $this->request->getPost('kode_ruang'),
            'nama_ruang' => $this->request->getPost('nama_ruang'),
            'kapasitas' => $this->request->getPost('kapasitas'),
            'nama_kegiatan' => $this->request->getPost('nama_kegiatan'),
            'nama_organisasi' => $this->request->getPost('nama_organisasi'),
            'tanggal_mulai' => $this->request->getPost('tanggal_mulai'),
            'waktu_mulai' => $this->request->getPost('waktu_mulai'),
            'tanggal_selesai' => $this->request->getPost('tanggal_selesai'),
            'waktu_selesai' => $this->request->getPost('waktu_selesai'),
            'status' => $this->request->getPost('status') ?? 'Diproses', // Default ke Diproses jika kosong
            'dok_peminjaman' => 'assets/dokumen/' . $dokPeminjamanName,
            'dok_ktm' => 'assets/ktm/' . $dokKTMName
        ]);

        return redirect()->to(base_url('adminpeminjaman'))->with('success', 'Peminjaman berhasil ditambahkan');
    }




    public function adminpeminjaman_detail($id_peminjaman)
    {
        $data['ruang'] = $this->RuanganModel->findAll(); // Jika hanya ingin semua data ruang
        $data['peminjaman'] = $this->PeminjamanModel->find($id_peminjaman); // Perbaiki ke model yang sesuai

        if (!$data['peminjaman']) {
            return redirect()->to('/adminpeminjaman')->with('error', 'Data peminjaman tidak ditemukan');
        }

        return view('backend/header')
        . view('backend/sidebar')
        . view('datapeminjaman_detail', $data)
        . view('backend/footer');
    }



    // First, modify your adminpeminjaman_edit function to add flash data:
    public function adminpeminjaman_edit($id)
    {
        // Update the booking record
        $this->PeminjamanModel->update($id, [
            'kode_ruang' => $this->request->getPost('kode_ruang'),
            'nama_ruang' => $this->request->getPost('nama_ruang'),
            'kapasitas' => $this->request->getPost('kapasitas'),
            'nama_kegiatan' => $this->request->getPost('nama_kegiatan'),
            'nama_organisasi' => $this->request->getPost('nama_organisasi'),
            'tanggal_mulai' => $this->request->getPost('tanggal_mulai'),
            'waktu_mulai' => $this->request->getPost('waktu_mulai'),
            'tanggal_selesai' => $this->request->getPost('tanggal_selesai'),
            'waktu_selesai' => $this->request->getPost('waktu_selesai'),
            'status' => $this->request->getPost('status'),
            'catatan' => $this->request->getPost('catatan'),
        ]);

        // Store booking ID and status in session for JavaScript to use
        session()->setFlashdata('statusUpdated', [
            'id' => $id,
            'status' => $this->request->getPost('status')
        ]);

        return redirect()->to(base_url('adminpeminjaman'))->with('success', 'Peminjaman berhasil diperbarui');
    }

    public function adminpeminjaman_hapus($id_peminjaman)
    {
        $this->PeminjamanModel->delete($id_peminjaman);
        return redirect()->to(base_url('adminpeminjaman'))->with('success', 'Peminjaman berhasil dihapus');
    }

    public function adminlaporan()
    {
        // Fetch all Peminjaman data
        $model = new \App\Models\PeminjamanModel();
        $data['peminjaman'] = $model->findAll();

        // Pass the data to the view
        return view('backend/header')
            . view('backend/sidebar')
            . view('laporan', $data)
            . view('backend/footer');
    }

    public function filterLaporanByTanggal()
    {
        // Validate the input
        $validationRules = [
            'tanggal_mulai' => 'required|valid_date',
            'tanggal_akhir' => 'required|valid_date'
        ];

        if (!$this->validate($validationRules)) {
            // If validation fails, return to the previous page with error
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        // Get the start and end dates from the form
        $tanggal_mulai = $this->request->getPost('tanggal_mulai');
        $tanggal_akhir = $this->request->getPost('tanggal_akhir');

        // Fetch Peminjaman data within the date range
        $peminjamanModel = new \App\Models\PeminjamanModel();
        $peminjaman = $peminjamanModel->where('tanggal_mulai >=', $tanggal_mulai)
            ->where('tanggal_selesai <=', $tanggal_akhir)
            ->findAll();

        // Prepare data for the view
        $data = [
            'peminjaman' => $peminjaman,
            'tanggal_mulai' => $tanggal_mulai,
            'tanggal_akhir' => $tanggal_akhir
        ];

        return view('backend/header')
            . view('backend/sidebar')
            . view('laporan', $data)
            . view('backend/footer');
    }

    public function cetakLaporanPeminjaman()
    {
        // Fetch all Peminjaman data
        $model = new \App\Models\PeminjamanModel();
        $data['peminjaman'] = $model->findAll();

        // Get current date for the report header
        $data['tanggal_cetak'] = date('Y-m-d H:i:s');
        $data['judul_laporan'] = 'Laporan Seluruh Data Peminjaman Ruangan';

        // Pass the data to the print view
        return view('cetak_laporan_peminjaman', $data);
    }

    public function cetakLaporanPeriodikPeminjaman()
    {
        // Get the start and end dates from the URL parameters
        $tanggal_mulai = $this->request->getGet('tanggal_mulai');
        $tanggal_akhir = $this->request->getGet('tanggal_akhir');

        // Validate the dates
        if (!$tanggal_mulai || !$tanggal_akhir) {
            return redirect()->to('/laporan_peminjaman')->with('error', 'Tanggal tidak valid');
        }

        // Fetch Peminjaman data within the date range
        $peminjamanModel = new \App\Models\PeminjamanModel();
        $peminjaman = $peminjamanModel->where('tanggal_mulai >=', $tanggal_mulai)
            ->where('tanggal_selesai <=', $tanggal_akhir)
            ->findAll();

        // Format dates for display
        $formatted_start = date('d-m-Y', strtotime($tanggal_mulai));
        $formatted_end = date('d-m-Y', strtotime($tanggal_akhir));

        // Prepare data for the view
        $data = [
            'peminjaman' => $peminjaman,
            'tanggal_mulai' => $tanggal_mulai,
            'tanggal_akhir' => $tanggal_akhir,
            'tanggal_cetak' => date('Y-m-d H:i:s'),
            'judul_laporan' => "Laporan Peminjaman Ruangan Periode: {$formatted_start} s/d {$formatted_end}"
        ];

        return view('cetak_laporan_peminjaman', $data);
    }

    // Main function as specified in your original code
    public function cetak_laporan()
    {
        // This function can serve as a router to the specific cetak_laporan functions
        // depending on your application's flow

        // Check if date parameters exist
        $tanggal_mulai = $this->request->getGet('tanggal_mulai');
        $tanggal_akhir = $this->request->getGet('tanggal_akhir');

        if ($tanggal_mulai && $tanggal_akhir) {
            // If date parameters exist, redirect to periodic report
            return redirect()->to("/cetakLaporanPeriodikPeminjaman?tanggal_mulai={$tanggal_mulai}&tanggal_akhir={$tanggal_akhir}");
        } else {
            // Otherwise, show all data
            return redirect()->to('/cetakLaporanPeminjaman');
        }
    }

}
