<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fakultas Kesehatan UDINUS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8fafb;
            color: #333;
        }

        /* Header Section */
        .header {
            background: linear-gradient(135deg, #268c43, #38d966);
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(0, 102, 255, 0.15);
        }

        .header h2 {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-weight: 300;
            letter-spacing: 1px;
        }

        

        /* Feature Cards */
        .feature-card {
            background-color: white;
            border-radius: 12px;
            padding: 1.5rem;
            height: 100%;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.05);
            transition: all 0.3s;
            text-align: center;
            border-bottom: 4px solid transparent;
        }

        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            border-bottom: 4px solid #268c43;
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            background-color: #c6f7d4;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            color: #268c43;
            font-size: 1.8rem;
        }

        .feature-card h4 {
            color: #268c43;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        /* Program Section */
        .program-section {
            padding: 4rem 0;
            background-color: #f0f6ff;
        }

        .section-title {
            text-align: center;
            margin-bottom: 3rem;
        }

        .section-title h2 {
            color: #268c43;
            font-weight: 700;
            position: relative;
            display: inline-block;
            padding-bottom: 10px;
            margin-bottom: 1rem;
        }

        .section-title h2::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background-color: #268c43;
        }

        .section-title p {
            color: #666;
            max-width: 700px;
            margin: 0 auto;
        }

        .program-card {
            background-color: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            height: 100%;
            transition: all 0.3s;
        }

        .program-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .program-card-img {
            height: 200px;
            background-color: #c6f7d4;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .program-card-img i {
            font-size: 4rem;
            color: #268c43;
        }

        .program-card-content {
            padding: 1.5rem;
        }

        .program-card-content h4 {
            color: #268c43;
            font-weight: 600;
            margin-bottom: 1rem;
        }

        .program-card-content p {
            color: #666;
            margin-bottom: 1.5rem;
        }

        .btn-program {
            background-color: transparent;
            border: 2px solid #268c43;
            color: #268c43;
            border-radius: 30px;
            padding: 0.5rem 1.5rem;
            font-weight: 500;
            transition: all 0.3s;
        }

        .btn-program:hover {
            background-color: #268c43;
            color: white;
        }

        /* Stats Section */
        .stats-section {
            padding: 4rem 0;
            background-color: #268c43;
            position: relative;
        }

        .stats-item {
            text-align: center;
            color: white;
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .stats-text {
            font-size: 1rem;
            opacity: 0.9;
        }

        /* Testimonial Section */
        .testimonial-section {
            padding: 4rem 0;
            background-color: #f8fafb;
        }

        .testimonial-card {
            background-color: white;
            border-radius: 12px;
            padding: 2rem;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
            position: relative;
        }

        .testimonial-card::before {
            content: '\201C';
            font-size: 5rem;
            color: #c6f7d4;
            position: absolute;
            top: -15px;
            left: 20px;
            font-family: serif;
            line-height: 1;
        }

        .testimonial-text {
            color: #555;
            font-style: italic;
            margin-bottom: 1.5rem;
        }

        .testimonial-author {
            display: flex;
            align-items: center;
        }

        .testimonial-author-img {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background-color: #c6f7d4;
            margin-right: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #268c43;
        }

        .testimonial-author-name {
            font-weight: 600;
            color: #333;
            margin-bottom: 0;
        }

        .testimonial-author-title {
            font-size: 0.85rem;
            color: #666;
        }

        /* CTA Section */
        .cta-section {
            padding: 4rem 0;
            background-color: #c6f7d4;
            text-align: center;
        }

        .cta-title {
            font-weight: 700;
            color: #268c43;
            margin-bottom: 1.5rem;
            font-size: 2rem;
        }

        .cta-text {
            color: #444;
            max-width: 700px;
            margin: 0 auto 2rem;
        }

        .btn-cta {
            background-color: #268c43;
            color: white;
            border-radius: 30px;
            padding: 0.75rem 2.5rem;
            font-weight: 600;
            border: none;
            box-shadow: 0 5px 15px rgba(38, 140, 67, 0.3);
            transition: all 0.3s;
        }

        .btn-cta:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(38, 140, 67, 0.4);
            background-color: #38d966;
        }

        .footer {
            background: linear-gradient(45deg, #268c43, #005792);
            color: white;
            text-align: center;
            padding: 2rem 0;
            border-radius: 40px 40px 0 0;
            margin-top: 3rem;
        }

        .footer-text {
            margin-bottom: 1rem;
            font-weight: 300;
        }

        .social-icons {
            margin-bottom: 1rem;
        }

        .social-icons a {
            color: white;
            margin: 0 0.5rem;
            font-size: 1.2rem;
            transition: all 0.3s;
        }

        .social-icons a:hover {
            transform: translateY(-3px);
            color: #ffc107;
        }


        .copyright {
            text-align: center;
            padding-top: 2rem;
            margin-top: 3rem;
            border-top: 1px solid #3a3f44;
            color: #888;
        }

        /* Responsive Adjustments */
        @media (max-width: 992px) {

            .feature-card,
            .program-card,
            .testimonial-card {
                margin-bottom: 1.5rem;
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 20px 20px;
            }

            .stats-item {
                margin-bottom: 2rem;
            }

            .cta-title {
                font-size: 1.8rem;
            }
        }
    </style>
</head>

<body>
    <!-- Navbar -->


    <!-- Header Section -->
    <div class="header text-center">
        <h2 style="font-family: poppins;">Profile</h2>
        <p style="font-family: poppins;">Fakultas Kesehatan UDINUS</p>
    </div>

    <!-- Features Section -->
    <section class="container mb-5">
        <div class="row">
            <div class="col-md-4 mb-4 mb-md-0">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-mortarboard"></i>
                    </div>
                    <h4 style="font-family: poppins;">Pendidikan Berkualitas</h4>
                    <p>Kurikulum terkini yang dirancang sesuai kebutuhan industri dan standar internasional.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4 mb-md-0">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-laptop"></i>
                    </div>
                    <h4 style="font-family: poppins;">Teknologi Modern</h4>
                    <p>Integrasi teknologi terkini dalam pembelajaran dan praktikum di bidang kesehatan.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-globe"></i>
                    </div>
                    <h4 style="font-family: poppins;">Jaringan Global</h4>
                    <p>Kolaborasi dengan institusi dalam dan luar negeri untuk pengalaman belajar internasional.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Program Section -->
    <section class="program-section">
        <div class="container">
            <div class="section-title">
                <h2 style="font-family: poppins;">Program Studi Unggulan</h2>
                <p>Fakultas Kesehatan UDINUS menawarkan program studi yang dirancang untuk mempersiapkan mahasiswa menjadi profesional kesehatan yang kompeten dan berdaya saing.</p>
            </div>

            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="program-card">
                        <div class="program-card-img">
                            <i class="bi bi-heart-pulse"></i>
                        </div>
                        <div class="program-card-content">
                            <h4 style="font-family: poppins;">S1 Kesehatan Masyarakat</h4>
                            <p>Menyiapkan lulusan untuk merancang dan menerapkan program kesehatan masyarakat secara profesional dengan pendekatan teknologi.</p>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="program-card">
                        <div class="program-card-img">
                            <i class="bi bi-clipboard2-pulse"></i>
                        </div>
                        <div class="program-card-content">
                            <h4 style="font-family: poppins;">D3 Rekam Medis & Informasi Kesehatan</h4>
                            <p>Fokus pada pengelolaan data medis dan informasi pasien menggunakan sistem informasi modern.</p>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="program-card">
                        <div class="program-card-img">
                            <i class="bi bi-pc-display"></i>
                        </div>
                        <div class="program-card-content">
                            <h4 style="font-family: poppins;">D4 Manajemen Informasi Kesehatan</h4>
                            <p>Menyiapkan lulusan yang kompeten di bidang manajemen data dan teknologi informasi kesehatan.</p>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="row">
                <div class="col-md-3 col-6 mb-md-0">
                    <div class="stats-item">
                        <div class="stats-number">3+</div>
                        <div class="stats-text">Program Studi</div>
                    </div>
                </div>
                <div class="col-md-3 col-6 mb-md-0">
                    <div class="stats-item">
                        <div class="stats-number">500+</div>
                        <div class="stats-text">Mahasiswa</div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stats-item">
                        <div class="stats-number">50+</div>
                        <div class="stats-text">Dosen Profesional</div>
                    </div>
                </div>
                <div class="col-md-3 col-6">
                    <div class="stats-item">
                        <div class="stats-number">20+</div>
                        <div class="stats-text">Mitra Kerjasama</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonial Section -->
    <section class="testimonial-section">
        <div class="container">
            <div class="section-title">
                <h2 style="font-family: poppins;">Testimonial</h2>
                <p>Pendapat dari alumni dan mitra kami tentang kualitas pendidikan Fakultas Kesehatan UDINUS.</p>
            </div>

            <div class="row">
                <div class="col-lg-6">
                    <div class="testimonial-card">
                        <p class="testimonial-text">Pendidikan di FKES UDINUS memberikan saya bekal yang sangat berharga untuk bersaing di dunia kerja. Kurikulum yang update dan dosen yang berpengalaman membuat saya siap menghadapi tantangan di bidang kesehatan.</p>
                        <div class="testimonial-author">
                            <div class="testimonial-author-img">
                                <i class="bi bi-person"></i>
                            </div>
                            <div>
                                <p class="testimonial-author-name">Anita Wijaya</p>
                                <p class="testimonial-author-title">Alumni S1 Kesehatan Masyarakat 2022</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="testimonial-card">
                        <p class="testimonial-text">Sebagai mitra industri, kami sangat terkesan dengan kompetensi lulusan FKES UDINUS. Mereka tidak hanya memiliki pengetahuan teoritis yang kuat tetapi juga keterampilan praktis dan teknologi yang dibutuhkan saat ini.</p>
                        <div class="testimonial-author">
                            <div class="testimonial-author-img">
                                <i class="bi bi-person"></i>
                            </div>
                            <div>
                                <p class="testimonial-author-name">Dr. Hadi Santoso</p>
                                <p class="testimonial-author-title">Direktur RS Medika Semarang</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <h2 class="cta-title" style="font-family: poppins;">Siap Bergabung dengan Kami?</h2>
            <p class="cta-text">Jadilah bagian dari generasi profesional kesehatan yang siap menghadapi tantangan global dengan bekal pengetahuan, keterampilan, dan teknologi terkini.</p>
            <a href="#" class="btn btn-cta">Daftar Sekarang</a>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <div class="footer-text">© 2025 Fakultas Kesehatan UDINUS - Semua Hak Dilindungi</div>
            <div class="social-icons">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-youtube"></i></a>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>