<?php
$session = \Config\Services::session();
?>

<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Booking - Fakultas Kesehatan UDINUS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --udinus-green: #268c43;
            --udinus-dark: #1a6b30;
            --udinus-light: #e6f6ec;
            --shadow-sm: 0 4px 10px rgba(38, 140, 67, 0.15);
            --shadow-md: 0 5px 15px rgba(0, 0, 0, 0.08);
            --radius-sm: 8px;
            --radius-md: 12px;
            --approved: #28a745;
            --pending: #ffc107;
            --rejected: #dc3545;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f6f2;
            color: #333;
        }

        .header {
            background: linear-gradient(135deg, #268c43, #38d966);
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(38, 140, 67, 0.15);
        }

        .header h2 {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-weight: 300;
            letter-spacing: 1px;
        }

        .card {
            border: none;
            border-radius: var(--radius-md);
            box-shadow: var(--shadow-md);
            overflow: hidden;
            margin-bottom: 25px;
        }

        .card-body {
            padding: 1.5rem;
        }

        .filter-container {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 1.5rem;
        }

        .filter-btn {
            background-color: white;
            color: #495057;
            border: 1px solid #dee2e6;
            border-radius: var(--radius-sm);
            padding: 8px 16px;
            font-size: 0.85rem;
            font-weight: 500;
            transition: all 0.2s;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
            cursor: pointer;
            display: flex;
            align-items: center;
        }

        .filter-btn i {
            margin-right: 6px;
        }

        .filter-btn.active {
            background-color: var(--udinus-green);
            color: white;
            border-color: var(--udinus-green);
        }

        .filter-btn:hover:not(.active) {
            background-color: #f1f8f3;
        }

        .table-container {
            border-radius: var(--radius-sm);
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
        }

        .table {
            margin-bottom: 0;
        }

        .table thead th {
            background-color: #f8f9fa;
            color: #495057;
            font-weight: 500;
            padding: 12px 16px;
            border-bottom: 1px solid #e9ecef;
            font-size: 0.9rem;
        }

        .table tbody td {
            padding: 14px 16px;
            vertical-align: middle;
            font-size: 0.9rem;
            border-bottom: 1px solid #f0f0f0;
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        .status-badge {
            padding: 5px 12px;
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            white-space: nowrap;
        }

        .status-badge i {
            margin-right: 5px;
            font-size: 0.8rem;
        }

        .status-approved {
            background-color: rgba(40, 167, 69, 0.15);
            color: var(--approved);
        }

        .status-pending {
            background-color: rgba(255, 193, 7, 0.15);
            color: #856404;
        }

        .status-rejected {
            background-color: rgba(220, 53, 69, 0.15);
            color: var(--rejected);
        }

        .btn-detail {
            background-color: var(--udinus-green);
            color: white;
            border: none;
            border-radius: var(--radius-sm);
            padding: 6px 14px;
            font-size: 0.8rem;
            font-weight: 500;
            transition: all 0.3s;
            box-shadow: 0 2px 5px rgba(38, 140, 67, 0.2);
            display: inline-flex;
            align-items: center;
            text-decoration: none;
        }

        .btn-detail:hover {
            background-color: var(--udinus-dark);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(38, 140, 67, 0.3);
        }

        .btn-detail i {
            margin-right: 5px;
        }

        .btn-cancel {
            background-color: #dc3545;
            color: white;
            border: none;
            border-radius: var(--radius-sm);
            padding: 6px 14px;
            font-size: 0.8rem;
            font-weight: 500;
            transition: all 0.3s;
            box-shadow: 0 2px 5px rgba(220, 53, 69, 0.2);
            display: inline-flex;
            align-items: center;
            text-decoration: none;
            margin-left: 5px;
        }

        .btn-cancel:hover {
            background-color: #c82333;
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(220, 53, 69, 0.3);
        }

        .btn-cancel i {
            margin-right: 5px;
        }

        .action-buttons {
            display: flex;
            gap: 5px;
        }

        .empty-state {
            text-align: center;
            padding: 3rem 1rem;
        }

        .empty-state i {
            font-size: 3rem;
            color: #d0d0d0;
            margin-bottom: 1rem;
        }

        .empty-state p {
            font-size: 1rem;
            color: #6c757d;
            margin-bottom: 0;
        }

        /* Modal styles */
        .modal-content {
            border-radius: var(--radius-md);
            border: none;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        }

        .modal-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid #eaeaea;
            padding: 1rem 1.5rem;
        }

        .modal-title {
            font-weight: 600;
            color: #333;
            font-size: 1.1rem;
        }

        .modal-body {
            padding: 1.5rem;
        }

        .modal-footer {
            border-top: 1px solid #eaeaea;
            padding: 1rem 1.5rem;
        }

        .btn-confirm-cancel {
            background-color: #dc3545;
            color: white;
            border: none;
            border-radius: var(--radius-sm);
            padding: 8px 16px;
            font-weight: 500;
            transition: all 0.3s;
        }

        .btn-confirm-cancel:hover {
            background-color: #c82333;
            color: white;
        }

        @media (max-width: 992px) {
            .filter-container {
                justify-content: center;
            }

            .table-responsive {
                border-radius: var(--radius-sm);
                overflow: hidden;
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 20px 20px;
            }

            .action-buttons {
                flex-direction: column;
                gap: 5px;
            }

            .btn-cancel {
                margin-left: 0;
                margin-top: 5px;
            }
        }

        @media (max-width: 576px) {
            .card-body {
                padding: 1rem;
            }

            .filter-btn {
                padding: 6px 12px;
                font-size: 0.8rem;
            }
        }
    </style>
</head>

<body>
    <div class="header text-center">
        <h2 style="font-family: poppins;">Riwayat Booking</h2>
        <p>Ruangan Fakultas Kesehatan UDINUS</p>
    </div>
    <div class="container">
        <div class="card">
            <div class="card-body">
                <!-- Filter Buttons -->
                <div class="filter-container">
                    <button class="filter-btn active" data-filter="all">
                        <i class="fas fa-list"></i> Semua
                    </button>
                    <button class="filter-btn" data-filter="Diproses">
                        <i class="fas fa-clock"></i> Diproses
                    </button>
                    <button class="filter-btn" data-filter="Disetujui">
                        <i class="fas fa-check-circle"></i> Disetujui
                    </button>
                    <button class="filter-btn" data-filter="Ditolak">
                        <i class="fas fa-times-circle"></i> Ditolak
                    </button>
                </div>

                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Nama Kegiatan</th>
                                    <th>Organisasi</th>
                                    <th>Ruangan</th>
                                    <th>Mulai</th>
                                    <th>Selesai</th>
                                    <th>Status</th>
                                    <th width="150">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($peminjaman)) : ?>
                                    <?php $no = 1;
                                    foreach ($peminjaman as $row) : ?>
                                        <?php if ($row['id_user'] == $session->get('id_user')) : ?>
                                            <tr class="booking-row" data-status="<?= esc($row['status']); ?>" data-id="<?= $row['id_peminjaman']; ?>">
                                                <td><?= $no++; ?></td>
                                                <td><?= esc($row['nama_kegiatan']); ?></td>
                                                <td><?= esc($row['nama_organisasi']); ?></td>
                                                <td><?= esc($row['nama_ruang']); ?></td>
                                                <td><?= date('d M Y', strtotime($row['tanggal_mulai'])); ?></td>
                                                <td><?= date('d M Y', strtotime($row['tanggal_selesai'])); ?></td>
                                                <td>
                                                    <span class="status-badge <?= $row['status'] == 'Disetujui' ? 'status-approved' : ($row['status'] == 'Ditolak' ? 'status-rejected' : 'status-pending'); ?>">
                                                        <i class="fas <?= $row['status'] == 'Disetujui' ? 'fa-check-circle' : ($row['status'] == 'Ditolak' ? 'fa-times-circle' : 'fa-clock'); ?>"></i>
                                                        <span class="status-text"><?= esc($row['status']); ?></span>
                                                    </span>
                                                </td>
                                                <td>
                                                    <div class="action-buttons">
                                                        <a href="<?= base_url('peminjamandetail/' . $row['id_peminjaman']); ?>" class="btn-detail">
                                                            <i class="fas fa-eye"></i> Detail
                                                        </a>
                                                        <?php if ($row['status'] == 'Diproses') : ?>
                                                            <a href="<?= base_url('cancel/' . $row['id_peminjaman']); ?>" class="btn-cancel" onclick="return confirm('Apakah Anda yakin ingin membatalkan peminjaman ruangan ini? Tindakan ini tidak dapat dibatalkan.');">
                                                                <i class="fas fa-times"></i> Batalkan
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <tr>
                                        <td colspan="8">
                                            <div class="empty-state">
                                                <i class="fas fa-folder-open"></i>
                                                <p>Anda belum memiliki riwayat peminjaman ruangan.</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Filter functionality
            const filterButtons = document.querySelectorAll('.filter-btn');
            const bookingRows = document.querySelectorAll('.booking-row');

            filterButtons.forEach(button => {
                button.addEventListener('click', function() {
                    // Remove active class from all buttons
                    filterButtons.forEach(btn => btn.classList.remove('active'));

                    // Add active class to clicked button
                    this.classList.add('active');

                    const filter = this.getAttribute('data-filter');

                    // Show/hide rows based on filter
                    bookingRows.forEach(row => {
                        if (filter === 'all' || row.getAttribute('data-status') === filter) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });

                    // Show empty state if no rows visible
                    const visibleRows = Array.from(bookingRows).filter(row => row.style.display !== 'none').length;
                    const tableBody = document.querySelector('tbody');
                    const emptyStateRow = tableBody.querySelector('tr.empty-filter-state');

                    if (visibleRows === 0) {
                        // Remove any existing empty filter state rows
                        if (emptyStateRow) {
                            emptyStateRow.remove();
                        }

                        // Add new empty state row
                        const newEmptyRow = document.createElement('tr');
                        newEmptyRow.className = 'empty-filter-state';
                        newEmptyRow.innerHTML = `
                            <td colspan="8">
                                <div class="empty-state">
                                    <i class="fas fa-filter"></i>
                                    <p>Tidak ada data peminjaman dengan status "${filter === 'all' ? 'tersedia' : filter}".</p>
                                </div>
                            </td>
                        `;
                        tableBody.appendChild(newEmptyRow);
                    } else {
                        // Remove empty filter state if we have visible rows
                        if (emptyStateRow) {
                            emptyStateRow.remove();
                        }
                    }
                });
            });
        });
    </script>
</body>

</html>