<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Peminjaman Ruangan - Fakultas Kesehatan UDINUS</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        :root {
           
        
            --udinus-green: #268c43;
            --udinus-dark: #1a6b30;
            --udinus-light: #e6f6ec;
            --shadow-sm: 0 4px 10px rgba(38, 140, 67, 0.15);
            --shadow-md: 0 5px 15px rgba(0, 0, 0, 0.08);
            --radius-sm: 8px;
            --radius-md: 12px;
            --approved: #28a745;
            --pending: #ffc107;
            --rejected: #dc3545;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f6f2;
            color: #333;
        }

        .header {
            background: linear-gradient(135deg, #268c43, #38d966);
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(38, 140, 67, 0.15);
        }

        .header h2 {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-weight: 300;
            letter-spacing: 1px;
        }

        .card {
            border: none;
            border-radius: var(--radius-md);
            box-shadow: var(--shadow-md);
            overflow: hidden;
            margin-bottom: 25px;
        }

        .card-body {
            padding: 1.5rem;
        }

        .form-section {
            background-color: #ffffff;
            padding: 1.5rem;
            border-radius: var(--radius-sm);
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            border-left: 4px solid var(--udinus-green);
        }

        .form-section:last-child {
            margin-bottom: 0;
        }

        .section-title {
            font-weight: 600;
            font-size: 1.1rem;
            margin-bottom: 1.2rem;
            color: #2c3e50;
            display: flex;
            align-items: center;
            padding-bottom: 0.7rem;
            border-bottom: 1px solid #eaeaea;
        }

        .section-title i {
            color: var(--udinus-green);
            margin-right: 0.6rem;
        }

        .form-group {
            margin-bottom: 1.2rem;
        }

        .form-group:last-child {
            margin-bottom: 0;
        }

        label {
            font-weight: 500;
            font-size: 0.9rem;
            color: #495057;
            margin-bottom: 0.5rem;
            display: block;
        }

        .form-control {
            border-radius: var(--radius-sm);
            padding: 0.6rem 1rem;
            border: 1px solid #dde2e5;
            background-color: #f8f9fa;
            transition: all 0.3s;
            font-size: 0.9rem;
        }

        .form-control:focus {
            box-shadow: 0 0 0 0.25rem rgba(38, 140, 67, 0.1);
            border-color: var(--udinus-green);
        }

        .form-control[readonly] {
            background-color: #f8f9fa;
            cursor: default;
            color: #495057;
        }

        .btn {
            border-radius: var(--radius-sm);
            padding: 0.6rem 1.2rem;
            font-weight: 500;
            transition: all 0.3s;
            font-size: 0.9rem;
        }

        .btn-primary {
            background-color: var(--udinus-green);
            border-color: var(--udinus-green);
            color: white;
        }

        .btn-primary:hover {
            background-color: var(--udinus-dark);
            border-color: var(--udinus-dark);
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(38, 140, 67, 0.3);
        }

        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #5a6268;
            transform: translateY(-1px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
        }

        .document-link {
            display: inline-block;
            padding: 0.5rem 1rem;
            background-color: #f1f8f3;
            border-radius: var(--radius-sm);
            color: var(--udinus-green);
            text-decoration: none;
            margin-top: 0.5rem;
            transition: all 0.3s;
            border: 1px solid #e1eefa;
            font-size: 0.85rem;
        }

        .document-link:hover {
            background-color: #e1eefa;
            color: var(--udinus-dark);
            transform: translateY(-1px);
        }

        .document-link i {
            margin-right: 0.4rem;
        }

        small {
            color: #6c757d;
            font-size: 0.8rem;
        }

        .status-badge {
            padding: 5px 12px;
            border-radius: 50px;
            font-size: 0.75rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            white-space: nowrap;
        }

        .status-badge i {
            margin-right: 5px;
            font-size: 0.8rem;
        }

        .status-approved {
            background-color: rgba(40, 167, 69, 0.15);
            color: var(--approved);
        }

        .status-pending {
            background-color: rgba(255, 193, 7, 0.15);
            color: #856404;
        }

        .status-rejected {
            background-color: rgba(220, 53, 69, 0.15);
            color: var(--rejected);
        }

        @media (max-width: 992px) {
            .row>[class*="col-"] {
                margin-bottom: 1rem;
            }

            .row>[class*="col-"]:last-child {
                margin-bottom: 0;
            }
        }

        @media (max-width: 768px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 20px 20px;
            }

            .form-section {
                padding: 1.2rem;
            }
        }

        @media (max-width: 576px) {
            .card-body {
                padding: 1rem;
            }

            .form-section {
                padding: 1rem;
            }
        }
    </style>
</head>

<body>
    <div class="header text-center" style="font-family: poppins;">
        <h2 style="font-family: poppins;">Detail Peminjaman Ruangan</h2>
        <p style="font-family: poppins;">Fakultas Kesehatan UDINUS</p>
    </div>

    <div class="container">
        <div class="card">
            <div class="card-body">
                <form action="<?= base_url('adminpeminjaman_edit/' . $peminjaman['id_peminjaman']); ?>" method="POST" enctype="multipart/form-data">

                    <div class="form-section">
                        <div class="section-title">
                            <i class="fas fa-building"></i> Informasi Ruangan
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_ruang">Nama Ruang</label>
                                    <input type="text" class="form-control" id="nama_ruang" name="nama_ruang" value="<?= $peminjaman['nama_ruang']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kapasitas">Kapasitas</label>
                                    <input type="number" class="form-control" id="kapasitas" name="kapasitas" value="<?= $peminjaman['kapasitas']; ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <div class="section-title">
                            <i class="fas fa-calendar-alt"></i> Informasi Kegiatan
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_kegiatan">Nama Kegiatan</label>
                                    <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" value="<?= $peminjaman['nama_kegiatan']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_organisasi">Nama Organisasi</label>
                                    <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" value="<?= $peminjaman['nama_organisasi']; ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <div class="section-title">
                            <i class="fas fa-clock"></i> Waktu Peminjaman
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="tanggal_mulai">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" value="<?= $peminjaman['tanggal_mulai']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="waktu_mulai">Waktu Mulai</label>
                                    <input type="time" class="form-control" id="waktu_mulai" name="waktu_mulai" value="<?= $peminjaman['waktu_mulai']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="tanggal_selesai">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" value="<?= $peminjaman['tanggal_selesai']; ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="waktu_selesai">Waktu Selesai</label>
                                    <input type="time" class="form-control" id="waktu_selesai" name="waktu_selesai" value="<?= $peminjaman['waktu_selesai']; ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <div class="section-title">
                            <i class="fas fa-file-alt"></i> Dokumen Pendukung
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dok_peminjaman">Dokumen Peminjaman</label>
                                    <small class="d-block mb-2">Download file dengan klik tombol dibawah ini</small>
                                    <?php if (!empty($peminjaman['dok_peminjaman'])): ?>
                                        <a href="<?= base_url('/' . $peminjaman['dok_peminjaman']); ?>" target="_blank" class="document-link">
                                            <i class="fas fa-file-pdf"></i> Lihat Dokumen Peminjaman
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">Tidak ada dokumen</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="dok_ktm">Dokumen KTM</label>
                                    <small class="d-block mb-2">Download file dengan klik tombol dibawah ini</small>
                                    <?php if (!empty($peminjaman['dok_ktm'])): ?>
                                        <a href="<?= base_url('/' . $peminjaman['dok_ktm']); ?>" target="_blank" class="document-link">
                                            <i class="fas fa-id-card"></i> Lihat KTM
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">Tidak ada dokumen</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <div class="section-title">
                            <i class="fas fa-info-circle"></i> Informasi Tambahan
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">Status Peminjaman</label>
                                    <?php
                                    $statusClass = '';
                                    $statusIcon = '';
                                    $statusText = $peminjaman['status'];

                                    switch (strtolower($peminjaman['status'])) {
                                        case 'disetujui':
                                        case 'approved':
                                            $statusClass = 'status-approved';
                                            $statusIcon = 'check-circle';
                                            break;
                                        case 'pending':
                                        case 'menunggu':
                                        case 'diproses':
                                            $statusClass = 'status-pending';
                                            $statusIcon = 'clock';
                                            break;
                                        case 'ditolak':
                                        case 'rejected':
                                            $statusClass = 'status-rejected';
                                            $statusIcon = 'times-circle';
                                            break;
                                    }
                                    ?>
                                    <div>
                                        <span class="status-badge <?= $statusClass ?>">
                                            <i class="fas fa-<?= $statusIcon ?>"></i> <?= $statusText ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="catatan">Catatan</label>
                                    <input type="text" class="form-control" id="catatan" name="catatan" value="<?= $peminjaman['catatan']; ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end mt-4">
                        <a href="<?= base_url('riwayatbooking'); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>