<div class="container-fluid py-4">
    <div class="card shadow-lg border-0 rounded-lg">
        <div class="card-body">
            <div class="row">
                <div class="col-12">
                    <!-- Header Section with improved styling -->
                    <div class="d-flex justify-content-between align-items-center mb-4 border-bottom pb-3">
                        <h4 class="m-0 text-primary fw-bold" style="font-family: 'Poppins', sans-serif;">
                            <i class="fas fa-clipboard-list me-2"></i>Laporan Peminjaman
                        </h4>

                        <!-- Button for printing all data -->
                        <?php if (!isset($tanggal_mulai) && !isset($tanggal_akhir)): ?>
                            <a href="<?= base_url('/cetakLaporanPeminjaman') ?>" class="btn btn-primary" style="font-family: 'Poppins', sans-serif;">
                                <i class="fas fa-print me-1"></i> Cetak Semua
                            </a>
                        <?php endif; ?>
                    </div>

                    <!-- Filter Section with improved layout -->
                    <div class="bg-light p-3 rounded-lg mb-4">
                        <form action="<?= base_url('/filterLaporanByTanggal') ?>" method="post" class="row g-3 align-items-end">
                            <?= csrf_field(); ?>
                            <div class="col-md-3">
                                <label for="tanggal_mulai" class="form-label fw-bold" style="font-family: 'Poppins', sans-serif;">
                                    <i class="far fa-calendar-alt me-1"></i> Tanggal Mulai
                                </label>
                                <input type="date" id="tanggal_mulai" name="tanggal_mulai"
                                    class="form-control" value="<?= isset($tanggal_mulai) ? $tanggal_mulai : '' ?>">
                            </div>
                            <div class="col-md-3">
                                <label for="tanggal_akhir" class="form-label fw-bold" style="font-family: 'Poppins', sans-serif;">
                                    <i class="far fa-calendar-alt me-1"></i> Tanggal Akhir
                                </label>
                                <input type="date" id="tanggal_akhir" name="tanggal_akhir"
                                    class="form-control" value="<?= isset($tanggal_akhir) ? $tanggal_akhir : '' ?>">
                            </div>
                            <div class="col-md-6">
                                <div class="d-flex gap-2">
                                    <button type="submit" id="applyFilter" class="btn btn-success">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>

                                    <?php if (isset($tanggal_mulai) && isset($tanggal_akhir)): ?>
                                        <a href="<?= base_url('/cetakLaporanPeriodikPeminjaman?tanggal_mulai=' . $tanggal_mulai . '&tanggal_akhir=' . $tanggal_akhir) ?>"
                                            class="btn btn-primary" style="font-family: 'Poppins', sans-serif;">
                                            <i class="fas fa-print me-1"></i> Cetak Laporan
                                        </a>
                                        <a href="<?= base_url('/laporan_peminjaman') ?>" class="btn btn-secondary" style="font-family: 'Poppins', sans-serif;">
                                            <i class="fas fa-undo me-1"></i> Reset
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <?php
                        $total = isset($peminjaman) ? count($peminjaman) : 0;
                        $disetujui = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                            return $p['status'] === 'Disetujui';
                        })) : 0;
                        $diproses = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                            return $p['status'] === 'Diproses';
                        })) : 0;
                        $ditolak = isset($peminjaman) ? count(array_filter($peminjaman, function ($p) {
                            return $p['status'] === 'Ditolak';
                        })) : 0;
                        ?>
                        <div class="col-xl-3 col-md-6 mb-2">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Total Peminjaman</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $total ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-2">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Disetujui</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $disetujui ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-2">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                Diproses</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $diproses ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-2">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Ditolak</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?= $ditolak ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Table with improved styling -->
                    <div class="table-responsive shadow-sm">
                        <table class="table table-hover align-middle table-bordered" id="dataTable">
                            <thead class="table-primary">
                                <tr>
                                    <th class="text-center" width="5%">No.</th>
                                    <th class="text-center" width="8%">Kode Ruang</th>
                                    <th class="text-center" width="12%">Nama Ruang</th>
                                    <th class="text-center" width="12%">Tanggal Mulai</th>
                                    <th class="text-center" width="12%">Tanggal Selesai</th>
                                    <th class="text-center" width="15%">Nama Kegiatan</th>
                                    <th class="text-center" width="15%">Nama Organisasi</th>
                                    <th class="text-center" width="10%">Status</th>
                                    <th class="text-center" width="8%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1; ?>
                                <?php if (isset($peminjaman) && $peminjaman): ?>
                                    <?php foreach ($peminjaman as $pinjam): ?>
                                        <tr>
                                            <td class="text-center"><?= $no++ ?></td>
                                            <td class="text-center"><?= esc($pinjam['kode_ruang']) ?></td>
                                            <td><?= esc($pinjam['nama_ruang']) ?></td>
                                            <td class="text-center">
                                                <?= date('d-m-Y', strtotime(esc($pinjam['tanggal_mulai']))) ?>
                                            </td>
                                            <td class="text-center">
                                                <?= date('d-m-Y', strtotime(esc($pinjam['tanggal_selesai']))) ?>
                                            </td>
                                            <td><?= esc($pinjam['nama_kegiatan']) ?></td>
                                            <td><?= esc($pinjam['nama_organisasi']) ?></td>
                                            <td class="text-center">
                                                <?php
                                                $statusClass = '';
                                                $statusBadge = '';
                                                $statusText = esc($pinjam['status']);
                                                if ($statusText == 'Disetujui') {
                                                    $statusBadge = 'badge bg-success';
                                                    $statusIcon = 'fas fa-check-circle me-1';
                                                } elseif ($statusText == 'Diproses') {
                                                    $statusBadge = 'badge bg-warning text-dark';
                                                    $statusIcon = 'fas fa-clock me-1';
                                                } elseif ($statusText == 'Ditolak') {
                                                    $statusBadge = 'badge bg-danger';
                                                    $statusIcon = 'fas fa-times-circle me-1';
                                                }
                                                ?>
                                                <span class="<?= $statusBadge ?>">
                                                    <i class="<?= $statusIcon ?>"></i>
                                                    <?= $statusText ?>
                                                </span>
                                            </td>
                                            <td class="text-center">
                                                <button type="button" class="btn btn-sm btn-info view-detail"
                                                    data-bs-toggle="modal" data-bs-target="#detailPeminjamanModal"
                                                    data-id="<?= $pinjam['id'] ?? '' ?>"
                                                    data-kode="<?= $pinjam['kode_ruang'] ?>"
                                                    data-nama="<?= $pinjam['nama_ruang'] ?>"
                                                    data-kapasitas="<?= $pinjam['kapasitas'] ?? '0' ?>"
                                                    data-kegiatan="<?= $pinjam['nama_kegiatan'] ?>"
                                                    data-organisasi="<?= $pinjam['nama_organisasi'] ?>"
                                                    data-tglmulai="<?= $pinjam['tanggal_mulai'] ?>"
                                                    data-tglselesai="<?= $pinjam['tanggal_selesai'] ?>"
                                                    data-waktumulai="<?= $pinjam['waktu_mulai'] ?? '00:00' ?>"
                                                    data-waktuselesai="<?= $pinjam['waktu_selesai'] ?? '00:00' ?>"
                                                    data-status="<?= $pinjam['status'] ?>"
                                                    data-catatan="<?= $pinjam['catatan'] ?? '-' ?>">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="9" class="text-center py-4">
                                            <div class="d-flex flex-column align-items-center justify-content-center">
                                                <i class="fas fa-folder-open fa-3x text-muted mb-3"></i>
                                                <p class="text-muted mb-0">Tidak ada data peminjaman ditemukan.</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Enhanced Modal Detail Peminjaman -->
<div class="modal fade" id="detailPeminjamanModal" tabindex="-1" aria-labelledby="detailPeminjamanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="detailPeminjamanModalLabel">
                    <i class="fas fa-info-circle me-2"></i>Detail Peminjaman
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="card shadow-sm h-100">
                            <div class="card-header bg-light">
                                <h6 class="m-0 font-weight-bold">Informasi Ruangan</h6>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%"><i class="fas fa-hashtag me-2 text-primary"></i>Kode Ruang</th>
                                        <td width="60%" id="detailKodeRuang"></td>
                                    </tr>
                                    <tr>
                                        <th><i class="fas fa-door-open me-2 text-primary"></i>Nama Ruang</th>
                                        <td id="detailNamaRuang"></td>
                                    </tr>
                                    <tr>
                                        <th><i class="fas fa-users me-2 text-primary"></i>Kapasitas</th>
                                        <td id="detailKapasitas"></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card shadow-sm h-100">
                            <div class="card-header bg-light">
                                <h6 class="m-0 font-weight-bold">Informasi Kegiatan</h6>
                            </div>
                            <div class="card-body">
                                <table class="table table-borderless">
                                    <tr>
                                        <th width="40%"><i class="fas fa-calendar-day me-2 text-primary"></i>Nama Kegiatan</th>
                                        <td width="60%" id="detailNamaKegiatan"></td>
                                    </tr>
                                    <tr>
                                        <th><i class="fas fa-building me-2 text-primary"></i>Organisasi</th>
                                        <td id="detailOrganisasi"></td>
                                    </tr>
                                    <tr>
                                        <th><i class="fas fa-clipboard-check me-2 text-primary"></i>Status</th>
                                        <td id="detailStatus"></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="m-0 font-weight-bold">Waktu Peminjaman</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%"><i class="fas fa-calendar-plus me-2 text-primary"></i>Tanggal Mulai</th>
                                                <td width="60%" id="detailTanggalMulai"></td>
                                            </tr>
                                            <tr>
                                                <th><i class="fas fa-clock me-2 text-primary"></i>Waktu Mulai</th>
                                                <td id="detailWaktuMulai"></td>
                                            </tr>
                                        </table>
                                    </div>
                                    <div class="col-md-6">
                                        <table class="table table-borderless">
                                            <tr>
                                                <th width="40%"><i class="fas fa-calendar-minus me-2 text-primary"></i>Tanggal Selesai</th>
                                                <td width="60%" id="detailTanggalSelesai"></td>
                                            </tr>
                                            <tr>
                                                <th><i class="fas fa-clock me-2 text-primary"></i>Waktu Selesai</th>
                                                <td id="detailWaktuSelesai"></td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12">
                        <div class="card shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="m-0 font-weight-bold"><i class="fas fa-sticky-note me-2 text-primary"></i>Catatan</h6>
                            </div>
                            <div class="card-body">
                                <p id="detailCatatan" class="form-control bg-light" style="min-height: 100px;"></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i>Tutup
                </button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for handling the modal data -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize DataTables if script is available
        if (typeof $.fn.DataTable !== 'undefined') {
            $('#dataTable').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json'
                },
                responsive: true
            });
        }

        // Handle the detail modal
        const detailButtons = document.querySelectorAll('.view-detail');
        detailButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Get data from attributes
                document.getElementById('detailKodeRuang').textContent = this.getAttribute('data-kode');
                document.getElementById('detailNamaRuang').textContent = this.getAttribute('data-nama');
                document.getElementById('detailKapasitas').textContent = this.getAttribute('data-kapasitas') + ' orang';
                document.getElementById('detailNamaKegiatan').textContent = this.getAttribute('data-kegiatan');
                document.getElementById('detailOrganisasi').textContent = this.getAttribute('data-organisasi');

                // Format dates
                const tglMulai = new Date(this.getAttribute('data-tglmulai'));
                const tglSelesai = new Date(this.getAttribute('data-tglselesai'));

                document.getElementById('detailTanggalMulai').textContent = tglMulai.toLocaleDateString('id-ID', {
                    weekday: 'long',
                    day: 'numeric',
                    month: 'long',
                    year: 'numeric'
                });
                document.getElementById('detailTanggalSelesai').textContent = tglSelesai.toLocaleDateString('id-ID', {
                    weekday: 'long',
                    day: 'numeric',
                    month: 'long',
                    year: 'numeric'
                });

                document.getElementById('detailWaktuMulai').textContent = this.getAttribute('data-waktumulai');
                document.getElementById('detailWaktuSelesai').textContent = this.getAttribute('data-waktuselesai');

                // Status with badge
                const status = this.getAttribute('data-status');
                let statusHtml = '';

                if (status === 'Disetujui') {
                    statusHtml = '<span class="badge bg-success"><i class="fas fa-check-circle me-1"></i>' + status + '</span>';
                } else if (status === 'Diproses') {
                    statusHtml = '<span class="badge bg-warning text-dark"><i class="fas fa-clock me-1"></i>' + status + '</span>';
                } else if (status === 'Ditolak') {
                    statusHtml = '<span class="badge bg-danger"><i class="fas fa-times-circle me-1"></i>' + status + '</span>';
                }

                document.getElementById('detailStatus').innerHTML = statusHtml;
                document.getElementById('detailCatatan').textContent = this.getAttribute('data-catatan');
            });
        });

        // Date range validation
        const tanggalMulai = document.getElementById('tanggal_mulai');
        const tanggalAkhir = document.getElementById('tanggal_akhir');

        if (tanggalMulai && tanggalAkhir) {
            tanggalMulai.addEventListener('change', function() {
                tanggalAkhir.min = this.value;
                if (tanggalAkhir.value && tanggalAkhir.value < this.value) {
                    tanggalAkhir.value = this.value;
                }
            });

            tanggalAkhir.addEventListener('change', function() {
                if (this.value && tanggalMulai.value && this.value < tanggalMulai.value) {
                    this.value = tanggalMulai.value;
                }
            });
        }
    });
</script>