<head>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }

        table {
            font-size: 14px;
            white-space: nowrap;
            /* Mencegah teks tabel melompat ke baris baru */
        }

        .table-responsive {
            overflow-x: auto;
            /* Menjadikan tabel bisa di-scroll jika terlalu lebar */
        }
    </style>
</head>

<body>
    <div class="card shadow-sm border-0">
        <div class="card-body" style="font-family: poppins;">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="text-dark">Daftar User</h5>
                <a href="<?php echo base_url('/adminuser_tambah'); ?>" class="btn btn-primary">+ Tambah User</a>
            </div>

            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light text-center">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Nama</th>
                            <th scope="col">Nomer Induk</th>
                            <th scope="col">No HP</th>
                            <th scope="col">Email</th>
                            <th scope="col">Role</th>
                            <th scope="col">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $no = 1;
                        foreach ($users as $user) : ?>
                            <tr class="text-center">
                                <th scope="row"><?= $no++; ?></th>
                                <td><?= esc($user['nama_user']); ?></td>
                                <td><?= esc($user['nomerinduk']); ?></td>
                                <td><?= esc($user['no_hp']); ?></td>
                                <td><?= esc($user['email']); ?></td>
                                <td>
                                    <?= ($user['role'] == 1) ? 'Admin' : (($user['role'] == 2) ? 'User' : 'Unknown'); ?>
                                </td>
                                <td>
                                    <a href="<?= base_url('/adminuser_detail/' . $user['id_user']); ?>" class="btn btn-warning btn-sm">Detail</a>
                                    <a href="<?= base_url('/adminuser_delete/' . $user['id_user']); ?>" class="btn btn-danger btn-sm">Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div> <!-- Akhir table-responsive -->
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>