<div class="card shadow-sm border-0">
    <div class="card-body" style="font-family: poppins;">
        <h5 class="card-title">Edit Ruangan</h5>
        <form action="<?= base_url('adminruangan_edit/' . $ruangan['kode_ruang']); ?>" method="POST" enctype="multipart/form-data">
            <?= csrf_field() ?>

            <div class="form-group">
                <label for="nama_ruang">Nama Ruang</label>
                <input type="text" class="form-control" id="nama_ruang" name="nama_ruang"
                    value="<?= old('nama_ruang', $ruangan['nama_ruang']) ?>" required>
            </div>

            <div class="form-group">
                <label for="kapasitas">Kapasitas</label>
                <input type="number" class="form-control" id="kapasitas" name="kapasitas"
                    value="<?= old('kapasitas', $ruangan['kapasitas']) ?>" required>
            </div>

            <div class="form-group">
                <label for="jenis_ruang">Jenis Ruang</label>
                <select class="form-control" id="jenis_ruang" name="jenis_ruang" required>
                    <option value="Ruang Kelas" <?= ($ruangan['jenis_ruang'] == 'Ruang Kelas') ? 'selected' : '' ?>>Ruang Kelas</option>
                    <option value="Ruang Aula" <?= ($ruangan['jenis_ruang'] == 'Ruang Aula') ? 'selected' : '' ?>>Ruang Aula</option>
                    <option value="Ruang Rapat" <?= ($ruangan['jenis_ruang'] == 'Ruang Rapat') ? 'selected' : '' ?>>Ruang Rapat</option>
                </select>
            </div>

            <div class="form-group">
                <label for="fasilitas">Fasilitas</label>
                <textarea class="form-control" id="fasilitas" name="fasilitas"
                    required><?= old('fasilitas', $ruangan['fasilitas']) ?></textarea>
            </div>

            <div class="form-group">
                <label for="foto">Foto</label>
                <input type="file" class="form-control-file" id="foto" name="foto">
                <small class="form-text text-muted">
                    Biarkan kosong jika tidak ingin mengubah foto
                </small>
                <?php if ($ruangan['foto']) : ?>
                    <div class="mt-2">
                        <img src="<?= base_url('assets/ruangan/' . $ruangan['foto']) ?>"
                            class="img-thumbnail" style="max-width: 200px;">
                    </div>
                <?php endif; ?>
            </div>

            <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
            <a href="<?= base_url('adminruangan') ?>" class="btn btn-secondary">Batal</a>
        </form>
    </div>
</div>