<head>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }

        table {
            font-size: 14px;
            white-space: nowrap;
            /* Mencegah teks tabel melompat ke baris baru */
        }

        .table-responsive {
            overflow-x: auto;
            /* Menjadikan tabel bisa di-scroll jika terlalu lebar */
        }
    </style>
</head>

<body>
    <div class="card shadow-sm border-0">
        <div class="card-body" style="font-family: poppins;">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="text-dark">Daftar Peminjaman</h5>
                <a href="<?= base_url('/adminpeminjaman_tambah'); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Peminjaman
                </a>
            </div>

            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light text-center">
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Nama Kegiatan</th>
                            <th scope="col">Organisasi</th>
                            <th scope="col">Nama Ruang</th>
                            <th scope="col">Tanggal Mulai</th>
                            <th scope="col">Tanggal Selesai</th>
                            <th scope="col">Status</th>
                            <th scope="col">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($peminjaman)) : ?>
                            <?php $no = 1;
                            foreach ($peminjaman as $row) : ?>
                                <tr>
                                    <th scope="row"><?= $no++; ?></th>
                                    <td><?= esc($row['nama_kegiatan']); ?></td>
                                    <td><?= esc($row['nama_organisasi']); ?></td>
                                    <td><?= esc($row['nama_ruang']); ?></td>
                                    <td><?= esc($row['tanggal_mulai']); ?></td>
                                    <td><?= esc($row['tanggal_selesai']); ?></td>
                                    <td>
                                        <?php if ($row['status'] == 'Disetujui') : ?>
                                            <span class="badge bg-success"><?= esc($row['status']); ?></span>
                                        <?php elseif ($row['status'] == 'Ditolak') : ?>
                                            <span class="badge bg-danger"><?= esc($row['status']); ?></span>
                                        <?php else : ?>
                                            <span class="badge bg-warning"><?= esc($row['status']); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?= base_url('adminpeminjaman_detail/' . $row['id_peminjaman']); ?>" class="btn btn-info btn-sm">Detail</a>
                                        <a href="<?= base_url('adminpeminjaman_hapus/' . $row['id_peminjaman']); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus?');">
                                            <i class="fas fa-trash"></i> Hapus
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="8" class="text-center">Tidak ada data peminjaman.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div> <!-- Akhir table-responsive -->
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>