<div class="container mt-4">
    <div class="row">
        <!-- Card for Room Details -->
        <div class="col-md-4 mb-4">
            <div class="card shadow p-4">
                <div class="card-body">
                    <h5 class="card-title text-center" style="font-family: Poppins;"><?= esc($ruang['nama_ruang']); ?></h5>

                    <!-- Foto Ruang -->
                    <div class="d-flex align-items-stretch">
                        <div class="card-body d-flex flex-column">
                            <img src="<?= base_url('/' . $ruang['foto']); ?>" class="card-img-top" alt="<?= esc($ruang['nama_ruang']); ?>" style="height: 200px; object-fit: cover;">
                            <br>
                            <p class="card-text flex-grow-1" style="font-family: Poppins; font-size: 14px;">
                                <strong>Kapasitas:</strong> <?= esc($ruang['kapasitas']); ?> orang<br>
                                <strong>Jenis:</strong> <?= esc($ruang['jenis_ruang']); ?><br>
                                <strong>Fasilitas:</strong> <?= esc($ruang['fasilitas']); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- Form for Adding Peminjaman -->
        <div class="col-md-8 mb-4">
            <div class="card shadow p-4">
                <div class="card-body">
                    <h5 class="card-title text-center" style="font-family: poppins; font-size: 24px; font-weight: 600;">Tambah Peminjaman</h5>
                    <form action="<?php echo base_url('peminjaman_tambah'); ?>" method="POST" enctype="multipart/form-data">
                        <div class="row">
                            <!-- Kolom Kiri -->
                            <div class="col-md-6 mb-4">
                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="kode_ruang" class="mb-2">Kode Ruang</label>
                                    <input type="text" class="form-control" id="kode_ruang" name="kode_ruang" value="<?= esc($ruang['kode_ruang']); ?>" readonly required>
                                </div>

                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="nama_ruang" class="mb-2">Nama Ruang</label>
                                    <input type="text" class="form-control" id="nama_ruang" name="nama_ruang" value="<?= esc($ruang['nama_ruang']); ?>" readonly required>
                                </div>

                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="kapasitas" class="mb-2">Kapasitas</label>
                                    <input type="number" class="form-control" id="kapasitas" name="kapasitas" required>
                                </div>

                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="nama_kegiatan" class="mb-2">Nama Kegiatan</label>
                                    <input type="text" class="form-control" id="nama_kegiatan" name="nama_kegiatan" placeholder="Masukkan Nama Kegiatan" required>
                                </div>
                            </div>

                            <!-- Kolom Kanan -->
                            <div class="col-md-6 mb-4">
                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="nama_organisasi" class="mb-2">Nama Organisasi</label>
                                    <input type="text" class="form-control" id="nama_organisasi" name="nama_organisasi" placeholder="Masukkan Nama Organisasi" required>
                                </div>

                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="tanggal_mulai" class="mb-2">Tanggal Mulai</label>
                                    <input type="date" class="form-control" id="tanggal_mulai" name="tanggal_mulai" required>
                                </div>

                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="tanggal_selesai" class="mb-2">Tanggal Selesai</label>
                                    <input type="date" class="form-control" id="tanggal_selesai" name="tanggal_selesai" required>
                                </div>
                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="status" class="mb-2">Status</label>
                                    <select class="form-control" id="status" name="status" required>
                                        <option value="Diproses">Diproses</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="dok_peminjaman" class="mb-2">Dokumen Peminjaman (PDF)</label>
                                    <input type="file" class="form-control" id="dok_peminjaman" name="dok_peminjaman" accept=".pdf" required>
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <div class="form-group mt-3" style="font-family: poppins;">
                                    <label for="dok_ktm" class="mb-2">Dokumen KTM (Gambar)</label>
                                    <input type="file" class="form-control" id="dok_ktm" name="dok_ktm" accept="image/*" required>
                                </div>
                            </div>
                        </div>



                        <div class="">
                            <button type="submit" class="btn btn-primary w-100" style="font-family: poppins;">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>