<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fakultas Kesehatan UDINUS</title>
    <link rel="icon" type="image/x-icon" href="<?= base_url('assets/favicon.ico'); ?>" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #268c43;
            --primary-light: #1a6b30;
            --secondary: #005792;
            --light: #e6f6ec;
            --dark: #343a40;
            --accent: #ffc107;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f1f5f9;
            color: #334155;
            line-height: 1.6;
            padding-top: 80px;
            /* Space for fixed navbar */
        }

        /* Navbar styles */
        #mainNav {
            background-color: white;
            z-index: 1030;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background: linear-gradient(135deg, #268c43, #38d966);
            padding: 2.5rem 0;
            border-radius: 0 0 30px 30px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 20px rgba(38, 140, 67, 0.15);
        }

        .header h2 {
            color: white;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-weight: 300;
            letter-spacing: 1px;
        }

        .header-content {
            position: relative;
            z-index: 2;
        }

        .main-card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            margin-bottom: 2rem;
            background: white;
            transition: transform 0.3s ease;
        }

        .main-card:hover {
            transform: translateY(-5px);
        }

        .card-header-custom {
            background: linear-gradient(to right, var(--primary), var(--primary-light));
            padding: 1.5rem;
            border-bottom: none;
        }

        .card-header-custom h4 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.4rem;
        }

        .section {
            margin-bottom: 2rem;
            position: relative;
            padding: 0 1rem;
        }

        .section-title {
            font-weight: 600;
            font-size: 1.35rem;
            margin-bottom: 1.3rem;
            color: var(--primary);
            display: flex;
            align-items: center;
            padding-bottom: 0.8rem;
            border-bottom: 2px solid #e2e8f0;
        }

        .section-icon {
            color: var(--primary);
            margin-right: 0.8rem;
            font-size: 1.2rem;
            background: rgba(12, 110, 78, 0.1);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .info-box {
            background-color: rgba(12, 110, 78, 0.08);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border-left: 5px solid var(--primary);
            transition: all 0.3s ease;
        }

        .info-box:hover {
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
            transform: translateY(-3px);
        }

        .info-box-title {
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 0.8rem;
            display: flex;
            align-items: center;
            font-size: 1.1rem;
        }

        .info-box-title i {
            color: var(--primary);
            margin-right: 0.8rem;
            font-size: 1.2rem;
            background: rgba(255, 255, 255, 0.6);
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .info-box-text {
            font-size: 0.95rem;
            color: #4b5563;
            line-height: 1.7;
        }

        .terms-list {
            list-style: none;
            padding-left: 0;
            margin-bottom: 1.8rem;
        }

        .terms-list li {
            padding: 0.9rem 1rem 0.9rem 3rem;
            position: relative;
            background-color: white;
            margin-bottom: 0.8rem;
            border-radius: 10px;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.04);
            transition: all 0.2s ease;
        }

        .terms-list li:hover {
            transform: translateX(5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
        }

        .terms-list li::before {
            content: "\f00c";
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 1rem;
            color: var(--primary);
            background: rgba(12, 110, 78, 0.1);
            width: 26px;
            height: 26px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.8rem;
        }

        .divider {
            height: 1px;
            background-color: #e2e8f0;
            margin: 2rem 0;
        }

        .download-section {
            background: linear-gradient(135deg, rgba(12, 110, 78, 0.08), rgba(5, 87, 146, 0.08));
            border-radius: 16px;
            padding: 2rem;
            margin-top: 2rem;
            border-left: 5px solid var(--primary);
            position: relative;
            overflow: hidden;
        }

        .download-section::before {
            content: "";
            position: absolute;
            top: -30px;
            right: -30px;
            width: 140px;
            height: 140px;
            border-radius: 50%;
            background: rgba(56, 217, 102, 0.1);
            z-index: 0;
        }

        .download-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 1.2rem;
            display: flex;
            align-items: center;
            position: relative;
            z-index: 1;
        }

        .download-title i {
            margin-right: 0.8rem;
            background: rgba(12, 110, 78, 0.1);
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .download-section p {
            position: relative;
            z-index: 1;
            margin-bottom: 1.5rem;
            color: #4b5563;
        }

        .btn-download {
            background: linear-gradient(to right, var(--primary), var(--secondary));
            border: none;
            border-radius: 10px;
            padding: 0.9rem 2rem;
            color: white;
            font-weight: 500;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 1;
            overflow: hidden;
        }

        .btn-download::before {
            content: "";
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: all 0.6s;
            z-index: -1;
        }

        .btn-download:hover::before {
            left: 100%;
        }

        .btn-download:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }

        .btn-download i {
            margin-right: 0.5rem;
        }

        .step-container {
            margin: 3rem 0;
        }

        .step-item {
            display: flex;
            margin-bottom: 2rem;
            position: relative;
        }

        .step-number {
            width: 50px;
            height: 50px;
            background: linear-gradient(45deg, var(--primary), var(--primary-light));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 1.2rem;
            margin-right: 1.5rem;
            flex-shrink: 0;
            box-shadow: 0 5px 15px rgba(12, 110, 78, 0.2);
        }

        .step-content {
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            flex-grow: 1;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .step-content:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        }

        .step-title {
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 0.8rem;
            font-size: 1.1rem;
        }

        .step-text {
            color: #4b5563;
            font-size: 0.95rem;
        }

        /* Video Tutorial Section Styles */
        .video-tutorial-section {
            background: linear-gradient(135deg, rgba(5, 87, 146, 0.05), rgba(12, 110, 78, 0.05));
            border-radius: 20px;
            padding: 2.5rem;
            margin: 3rem 0;
            border: 1px solid rgba(38, 140, 67, 0.1);
            position: relative;
            overflow: hidden;
        }

        .video-tutorial-section::before {
            content: "";
            position: absolute;
            top: -50px;
            left: -50px;
            width: 200px;
            height: 200px;
            border-radius: 50%;
            background: rgba(5, 87, 146, 0.05);
            z-index: 0;
        }

        .video-tutorial-section::after {
            content: "";
            position: absolute;
            bottom: -30px;
            right: -30px;
            width: 150px;
            height: 150px;
            border-radius: 50%;
            background: rgba(38, 140, 67, 0.05);
            z-index: 0;
        }

        .video-container {
            position: relative;
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
            background: #000;
            z-index: 1;
        }

        .video-container video {
            width: 100%;
            height: auto;
            display: block;
        }

        .video-placeholder {
            position: relative;
            width: 100%;
            height: 450px;
            background: linear-gradient(135deg, #1e293b, #334155);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 20px;
            overflow: hidden;
        }

        .video-placeholder-content {
            text-align: center;
            color: white;
            z-index: 2;
        }

        .video-placeholder-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
            color: var(--primary);
        }

        .video-placeholder h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            font-weight: 600;
        }

        .video-placeholder p {
            font-size: 1rem;
            opacity: 0.8;
            margin-bottom: 1.5rem;
        }

        .video-play-btn {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            border: none;
            padding: 1rem 2rem;
            border-radius: 50px;
            color: white;
            font-weight: 500;
            transition: all 0.3s ease;
            cursor: pointer;
            box-shadow: 0 8px 25px rgba(38, 140, 67, 0.3);
        }

        .video-play-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 30px rgba(38, 140, 67, 0.4);
        }

        .video-tutorial-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
            position: relative;
            z-index: 1;
        }

        .tutorial-card {
            background: white;
            border-radius: 15px;
            padding: 1.5rem;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        .tutorial-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.12);
        }

        .tutorial-card-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(45deg, var(--primary), var(--primary-light));
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 1rem;
        }

        .tutorial-card-icon i {
            font-size: 1.5rem;
            color: white;
        }

        .tutorial-card h5 {
            color: var(--primary);
            font-weight: 600;
            margin-bottom: 0.8rem;
            font-size: 1.1rem;
        }

        .tutorial-card p {
            color: #6b7280;
            font-size: 0.9rem;
            line-height: 1.6;
            margin-bottom: 1rem;
        }

        .tutorial-duration {
            display: inline-flex;
            align-items: center;
            background: rgba(38, 140, 67, 0.1);
            color: var(--primary);
            padding: 0.3rem 0.8rem;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 500;
        }

        .tutorial-duration i {
            margin-right: 0.3rem;
        }

        .faq-item {
            margin-bottom: 1.2rem;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0, 0, 0, 0.05);
            background-color: white;
        }

        .faq-question {
            padding: 1.2rem;
            background-color: rgba(12, 110, 78, 0.05);
            cursor: pointer;
            font-weight: 500;
            color: var(--primary);
            position: relative;
            transition: all 0.3s ease;
        }

        .faq-question:hover {
            background-color: rgba(12, 110, 78, 0.1);
        }

        .faq-question::after {
            content: "\f107";
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            right: 1.2rem;
            transition: all 0.3s ease;
        }

        .faq-question.active::after {
            transform: rotate(180deg);
        }

        .faq-answer {
            padding: 0 1.2rem;
            max-height: 0;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .faq-answer.show {
            padding: 1.2rem;
            max-height: 500px;
        }

        .footer {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
            text-align: center;
            padding: 2rem 0;
            border-radius: 40px 40px 0 0;
            margin-top: 3rem;
        }

        .footer-text {
            margin-bottom: 1rem;
            font-weight: 300;
        }

        .social-icons {
            margin-bottom: 1rem;
        }

        .social-icons a {
            color: white;
            margin: 0 0.5rem;
            font-size: 1.2rem;
            transition: all 0.3s;
        }

        .social-icons a:hover {
            transform: translateY(-3px);
            color: var(--accent);
        }

        @media (max-width: 768px) {
            .header {
                padding: 2rem 0;
                border-radius: 0 0 25px 25px;
            }

            .header h2 {
                font-size: 2rem;
            }

            .main-card {
                border-radius: 15px;
            }

            .step-item {
                flex-direction: column;
            }

            .step-number {
                margin-bottom: 1rem;
                margin-right: 0;
            }

            .download-section,
            .info-box {
                padding: 1.2rem;
            }

            .video-tutorial-section {
                padding: 1.5rem;
            }

            .video-placeholder {
                height: 300px;
            }

            .video-placeholder-icon {
                font-size: 3rem;
            }

            .tutorial-card {
                padding: 1.2rem;
            }

            .video-tutorial-grid {
                grid-template-columns: 1fr;
                gap: 1.5rem;
            }
        }
    </style>
</head>

<body>
    <div class="header">
        <div class="header-content text-center">
            <h2 style="font-family: poppins;">Tata Cara Peminjaman</h2>
            <p style="font-family: poppins;">Ruangan Fakultas Kesehatan UDINUS</p>
        </div>
    </div>

    <div class="container pb-5">
        <div class="card main-card">
            <div class="card-header-custom">
                <h4 class="text-center" style="font-family: poppins;"> Sistem Booking Ruangan</h4>
            </div>

            <div class="card-body p-4">
                <div class="info-box">
                    <div class="info-box-title" style="font-family: poppins;">
                        <i class="fas fa-info-circle"></i> Informasi Penting
                    </div>
                    <div class="info-box-text">
                        Mohon membaca syarat dan ketentuan booking ruangan dengan seksama sebelum melakukan pemesanan. Sistem ini dirancang untuk memudahkan pengelolaan ruangan di Fakultas Kesehatan UDINUS.
                    </div>
                </div>

                <div class="step-container">
                    <h4 class="section-title mb-4" style="font-family: poppins;">
                        <div class="section-icon"><i class="fas fa-tasks"></i></div>
                        Proses Booking Ruangan
                    </h4>

                    <div class="step-item">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <div class="step-title">Registrasi</div>
                            <div class="step-text">Pastikan Anda sudah terdaftar sebagai pengguna di sistem booking ruangan Fakultas Kesehatan UDINUS.</div>
                        </div>
                    </div>

                    <div class="step-item">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <div class="step-title">Cek Ketersediaan</div>
                            <div class="step-text">Periksa ketersediaan ruangan pada tanggal dan jam yang Anda inginkan melalui sistem booking online.</div>
                        </div>
                    </div>

                    <div class="step-item">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <div class="step-title">Submit Permohonan</div>
                            <div class="step-text">Lengkapi formulir permohonan dan upload dokumen pendukung yang diperlukan.</div>
                        </div>
                    </div>

                    <div class="step-item">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            <div class="step-title">Konfirmasi</div>
                            <div class="step-text">Tunggu konfirmasi dari administrator sistem. Anda akan mendapatkan notifikasi via email.</div>
                        </div>
                    </div>
                </div>

                <div class="video-tutorial-section">
                    <h4 class="section-title text-center mb-4" style="font-family: poppins;">
                        <div class="section-icon"><i class="fas fa-play-circle"></i></div>
                        Video Tutorial Booking Ruangan
                    </h4>

                    <div class="video-container">
                        <!-- YouTube Video Embed -->
                        <div class="video-wrapper" id="videoWrapper">
                            <!-- Placeholder sebelum video dimuat -->
                            <div class="video-placeholder" id="videoPlaceholder">
                                <div class="video-placeholder-content">
                                    <div class="video-placeholder-icon">
                                        <i class="fas fa-play-circle"></i>
                                    </div>
                                    <h3>Tutorial Lengkap Booking Ruangan</h3>
                                    <p>Pelajari cara menggunakan sistem booking ruangan dengan mudah</p>
                                    <button class="video-play-btn" onclick="playVideoTutorial()">
                                        <i class="fas fa-play me-2"></i>Putar Video Tutorial
                                    </button>
                                </div>
                            </div>

                            <!-- YouTube iframe yang akan muncul setelah tombol diklik -->
                            <iframe id="youtubeVideo"
                                width="100%"
                                height="400"
                                frameborder="0"
                                allowfullscreen
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                                style="display: none; border-radius: 12px;">
                            </iframe>
                        </div>
                    </div>
                </div>

                <div class="video-tutorial-grid">
                    <div class="tutorial-card">
                        <div class="tutorial-card-icon">
                            <i class="fas fa-user-plus"></i>
                        </div>
                        <h5>Cara Registrasi</h5>
                        <p>Panduan lengkap untuk mendaftar dan membuat akun baru di sistem booking ruangan Fakultas Kesehatan UDINUS.</p>
                        <div class="tutorial-duration">
                            <i class="fas fa-clock"></i>3 menit
                        </div>
                    </div>

                    <div class="tutorial-card">
                        <div class="tutorial-card-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <h5>Proses Booking</h5>
                        <p>Langkah demi langkah cara melakukan booking ruangan, mulai dari pemilihan ruangan hingga konfirmasi.</p>
                        <div class="tutorial-duration">
                            <i class="fas fa-clock"></i>5 menit
                        </div>
                    </div>

                    <div class="tutorial-card">
                        <div class="tutorial-card-icon">
                            <i class="fas fa-file-upload"></i>
                        </div>
                        <h5>Upload Dokumen</h5>
                        <p>Tutorial cara mengunggah dokumen pendukung yang diperlukan untuk proses persetujuan booking ruangan.</p>
                        <div class="tutorial-duration">
                            <i class="fas fa-clock"></i>2 menit
                        </div>
                    </div>

                </div>
            </div>

            <div class="section mt-5">
                <h4 class="section-title" style="font-family: poppins;">
                    <div class="section-icon"><i class="fas fa-clipboard-list"></i></div>
                    Persyaratan Umum
                </h4>
                <ul class="terms-list">
                    <li>Pemesan harus terdaftar sebagai pengguna di sistem booking ruangan Fakultas Kesehatan.</li>
                    <li>Booking dilakukan minimal H-3 sebelum penggunaan ruangan untuk persiapan.</li>
                    <li>Durasi maksimal penggunaan ruangan adalah 10 jam per hari.</li>
                    <li>Pengguna bertanggung jawab penuh terhadap kondisi ruangan selama masa penggunaan.</li>
                </ul>
            </div>

            <div class="section">
                <h4 class="section-title" style="font-family: poppins;">
                    <div class="section-icon"><i class="fas fa-file-alt"></i></div>
                    Dokumen yang Harus Disertakan
                </h4>
                <ul class="terms-list">
                    <li>Upload identitas (KTP/Kartu Mahasiswa/Kartu Pegawai) pada sistem dalam format PDF.</li>
                    <li>Surat permohonan penggunaan ruangan yang telah ditandatangani oleh pemohon dan pejabat berwenang.</li>
                    <li>Apabila kegiatan melibatkan pihak eksternal, lampirkan juga surat kerjasama atau MoU.</li>
                </ul>
            </div>

            <div class="section">
                <h4 class="section-title" style="font-family: poppins;">
                    <div class="section-icon"><i class="fas fa-money-bill-wave"></i></div>
                    Biaya dan Pembatalan
                </h4>
                <ul class="terms-list">
                    <li>Jika terdapat biaya sewa, harus dibayarkan melalui transfer bank sebelum pelaksanaan acara.</li>
                    <li>Pembatalan booking maksimal H-1 sebelum tanggal penggunaan, jika lebih akan dikenakan denda 50% dari biaya sewa.</li>
                    <li>Pengembalian dana hanya berlaku untuk pembatalan yang dilakukan minimal 3 hari sebelum tanggal penggunaan.</li>
                </ul>
            </div>

            <div class="section">
                <h4 class="section-title" style="font-family: poppins;">
                    <div class="section-icon"><i class="fas fa-question-circle"></i></div>
                    Pertanyaan Umum
                </h4>

                <div class="faq-item">
                    <div class="faq-question">Berapa lama proses persetujuan peminjaman ruangan?</div>
                    <div class="faq-answer">
                        Proses persetujuan peminjaman ruangan biasanya memakan waktu 1-2 hari kerja sejak permohonan diterima secara lengkap oleh sistem.
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question">Apakah ruangan dilengkapi dengan fasilitas proyektor dan sound system?</div>
                    <div class="faq-answer">
                        Ya, sebagian besar ruangan di Fakultas Kesehatan UDINUS dilengkapi dengan proyektor dan sound system. Namun, silakan verifikasi fasilitas spesifik untuk ruangan yang Anda pilih pada detail informasi ruangan di sistem booking.
                    </div>
                </div>

                <div class="faq-item">
                    <div class="faq-question">Bagaimana cara membatalkan peminjaman ruangan?</div>
                    <div class="faq-answer">
                        Pembatalan dapat dilakukan melalui sistem dengan masuk ke akun Anda, memilih menu "Booking Saya", dan klik tombol "Batalkan" pada booking yang ingin dibatalkan. Pastikan pembatalan dilakukan minimal H-1 untuk menghindari denda.
                    </div>
                </div>
            </div>

            <div class="divider"></div>

            <div class="download-section">
                <h5 class="download-title" style="font-family: poppins;">
                    <i class="fas fa-download"></i> Template Dokumen
                </h5>
                <p>Unduh template surat permohonan penggunaan ruangan untuk mempermudah proses booking:</p>
                <a href="<?= base_url('/downloadTemplate'); ?>" class="btn btn-download">
                    <i class="fas fa-file-word me-2"></i> Download Template Surat
                </a>
            </div>
        </div>
    </div>

    <div class="text-center mt-4">
        <p class="text-muted">Untuk informasi lebih lanjut, silakan hubungi Bagian Administrasi Fakultas Kesehatan UDINUS</p>
        <p class="text-muted"><i class="fas fa-phone me-2"></i>024-3517261 | <i class="fas fa-envelope me-2"></i>fkes@dinus.ac.id</p>
    </div>
    </div>

    <footer class="footer">
        <div class="container">
            <div class="footer-text">© 2025 Fakultas Kesehatan UDINUS - Semua Hak Dilindungi</div>
            <div class="social-icons">
                <a href="#"><i class="fab fa-facebook"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-youtube"></i></a>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Script untuk FAQ accordion
        document.addEventListener('DOMContentLoaded', function() {
            const faqQuestions = document.querySelectorAll('.faq-question');

            faqQuestions.forEach(question => {
                question.addEventListener('click', function() {
                    const answer = this.nextElementSibling;

                    // Toggle active class
                    this.classList.toggle('active');

                    // Toggle answer visibility
                    if (answer.classList.contains('show')) {
                        answer.classList.remove('show');
                    } else {
                        answer.classList.add('show');
                    }
                });
            });
        });

        function playVideoTutorial() {
            // Ganti VIDEO_ID dengan ID video YouTube yang sebenarnya
            const VIDEO_ID = 'DPVYGBQplxk'; // Contoh ID, ganti dengan ID video Anda

            // Sembunyikan placeholder
            document.getElementById('videoPlaceholder').style.display = 'none';

            // Tampilkan dan load YouTube video
            const youtubeVideo = document.getElementById('youtubeVideo');
            youtubeVideo.src = `https://www.youtube.com/embed/${VIDEO_ID}?autoplay=1&rel=0&modestbranding=1`;
            youtubeVideo.style.display = 'block';
        }

        // Alternatif: Buka di tab baru (uncomment jika ingin menggunakan ini)
        /*
        function playVideoTutorial() {
            const VIDEO_ID = 'dQw4w9WgXcQ'; // Ganti dengan ID video Anda
            window.open(`https://www.youtube.com/watch?v=${VIDEO_ID}`, '_blank');
        }
        */

        // Smooth scroll animation for tutorial cards
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Apply animation to tutorial cards
        document.addEventListener('DOMContentLoaded', function() {
            const tutorialCards = document.querySelectorAll('.tutorial-card');

            tutorialCards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                card.style.transition = `opacity 0.6s ease ${index * 0.1}s, transform 0.6s ease ${index * 0.1}s`;
                observer.observe(card);
            });
        });
    </script>
</body>

</html>