<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        if (!session()->get('logged_in')) {
            return redirect()->to('/login')->with('error', 'Silakan login terlebih dahulu.');
        }

        // Jika role admin (1), hanya boleh ke dashboard
        if ($arguments && $arguments[0] == 'admin' && session()->get('role') != 1) {
            return redirect()->to('/index')->with('error', 'Akses ditolak.');
        }

        // Jika role user (2), hanya boleh ke index
        if ($arguments && $arguments[0] == 'user' && session()->get('role') != 2) {
            return redirect()->to('/dashboard')->with('error', 'Akses ditolak.');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Tidak perlu aksi tambahan setelah request
    }
}
