<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Frontend::index', ['as' => 'home']); // Pastikan ini ada!
$routes->get('index', 'Frontend::index', ['as' => 'index']);
$routes->get('ruangan', 'Frontend::ruangan', ['as' => 'ruangan']);
$routes->get('booking/(:segment)', 'Frontend::booking/$1');
$routes->post('booking_tambah', 'Frontend::booking_tambah');
$routes->get('ruangan_detail/(:segment)', 'Frontend::ruangan_detail/$1', ['as' => 'ruangan_detail']);
$routes->get('tentang', 'Frontend::tentang', ['as' => 'tentang']);
$routes->get('downloadTemplate', 'Frontend::downloadTemplate');
$routes->get('api/peminjaman/(:segment)/(:num)/(:num)', 'Frontend::getPeminjamanByRoom/$1/$2/$3');
$routes->get('login', 'Frontend::login', ['as' => 'login']);
$routes->post('processLogin', 'Frontend::processLogin', ['as' => 'processLogin']);
$routes->get('register', 'Frontend::register', ['as' => 'register']);
$routes->post('processRegister', 'Frontend::processRegister', ['as' => 'processRegister']);
$routes->get('logout', 'Frontend::logout', ['as' => 'logout']);
$routes->get('riwayatbooking', 'Frontend::riwayatbooking', ['as' => 'riwayatbooking']);
$routes->get('peminjamandetail/(:num)', 'Frontend::peminjamandetail/$1');
$routes->get('cancel/(:num)', 'Frontend::cancel/$1');


/**
 * Backend routes - hanya bisa diakses jika user sudah login
 */
$routes->get('dashboard', 'Dashboard::dashboard', ['filter' => 'auth', 'as' => 'dashboard']);


$routes->get('adminuser', 'Dashboard::adminuser');
$routes->get('adminuser_tambah', 'Dashboard::adminuser_tambah');
$routes->post('user_tambah', 'Dashboard::user_tambah');
$routes->get('adminuser_detail/(:num)', 'Dashboard::adminuser_detail/$1');
$routes->post('adminuser_edit/(:num)', 'Dashboard::adminuser_edit/$1');
$routes->get('adminuser_delete/(:num)', 'Dashboard::adminuser_delete/$1');

$routes->get('adminruangan', 'Dashboard::adminruangan');
$routes->get('adminruangan_tambah', 'Dashboard::adminruangan_tambah');
$routes->post('ruangan_tambah', 'Dashboard::ruangan_tambah');
$routes->get('adminruangan_detail/(:segment)', 'Dashboard::adminruangan_detail/$1');
$routes->get('adminruangan_delete/(:segment)', 'Dashboard::adminruangan_delete/$1');
$routes->post('adminruangan_edit/(:segment)', 'Dashboard::adminruangan_edit/$1');




$routes->get('adminpeminjaman', 'Dashboard::adminpeminjaman');
$routes->get('adminpeminjaman_tambah', 'Dashboard::adminpeminjaman_tambah');
$routes->post('peminjaman_tambah', 'Dashboard::peminjaman_tambah');
$routes->get('adminpeminjaman_detail/(:num)', 'Dashboard::adminpeminjaman_detail/$1');
$routes->get('adminpeminjaman_hapus/(:num)', 'Dashboard::adminpeminjaman_hapus/$1');
$routes->post('adminpeminjaman_edit/(:num)', 'Dashboard::adminpeminjaman_edit/$1');

// Existing report routes
$routes->get('adminlaporan', 'Dashboard::adminlaporan');
$routes->post('filterLaporanByTanggal', 'Dashboard::filterLaporanByTanggal');

// New print report routes
$routes->get('laporan_peminjaman', 'Dashboard::adminlaporan'); // Alias for adminlaporan for better URL structure
$routes->get('cetakLaporanPeminjaman', 'Dashboard::cetakLaporanPeminjaman');
$routes->get('cetakLaporanPeriodikPeminjaman', 'Dashboard::cetakLaporanPeriodikPeminjaman');
$routes->get('cetak_laporan', 'Dashboard::cetak_laporan');