<?php
// Turn off all error reporting to prevent HTML output
error_reporting(0);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

header('Content-Type: application/json');

// Function to send JSON response and exit
function sendResponse($data)
{
    echo json_encode($data);
    exit();
}

// Handle only POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse([
        'status' => 0,
        'result' => 0,
        'message' => 'Only POST requests are accepted.'
    ]);
}

try {
    // Create fresh database connection
    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "pinjamruang"; // Make sure this database exists!

    $conn = new mysqli($servername, $username, $password, $dbname);

    // Better error checking for connection
    if ($conn->connect_error) {
        error_log("Database connection failed: " . $conn->connect_error);
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }

    $conn->set_charset("utf8");

    // Directory paths for file uploads
    $base_path = $_SERVER['DOCUMENT_ROOT'] . "/pinjamruang/public/";
    $dokumen_dir = $base_path . "assets/dokumen/";
    $ktm_dir = $base_path . "assets/ktm/";

    // Create directories if they don't exist
    if (!file_exists($dokumen_dir)) {
        mkdir($dokumen_dir, 0777, true);
    }
    if (!file_exists($ktm_dir)) {
        mkdir($ktm_dir, 0777, true);
    }

    // Get data from request
    $content_type = $_SERVER['CONTENT_TYPE'] ?? '';

    if (strpos($content_type, 'application/json') !== false) {
        $postData = file_get_contents('php://input');
        $data = json_decode($postData, true);
        if (!$data) {
            throw new Exception("Invalid JSON data");
        }
    } else {
        $data = $_POST;
    }

    // Log the received data for debugging
    error_log("Received data: " . print_r($data, true));

    // Extract and validate required fields
    $required_fields = [
        'id_user',
        'kode_ruang',
        'nama_ruang',
        'kapasitas',
        'nama_kegiatan',
        'nama_organisasi',
        'tanggal_mulai',
        'waktu_mulai',
        'tanggal_selesai',
        'waktu_selesai'
    ];

    foreach ($required_fields as $field) {
        if (empty($data[$field])) {
            throw new Exception("Missing required field: $field");
        }
    }

    // Assign variables
    $id_user = $data['id_user'];
    $kode_ruang = $data['kode_ruang'];
    $nama_ruang = $data['nama_ruang'];
    $kapasitas = $data['kapasitas'];
    $nama_kegiatan = $data['nama_kegiatan'];
    $nama_organisasi = $data['nama_organisasi'];
    $tanggal_mulai = $data['tanggal_mulai'];
    $waktu_mulai = $data['waktu_mulai'];
    $tanggal_selesai = $data['tanggal_selesai'];
    $waktu_selesai = $data['waktu_selesai'];
    $status = $data['status'] ?? 'Diproses';
    $catatan = $data['catatan'] ?? '';

    // Handle file uploads - including base64 data
    $dok_peminjaman = '';
    $dok_ktm = '';

    // Process dokumen peminjaman file (base64 or regular upload)
    if (isset($_FILES['dok_peminjaman']) && $_FILES['dok_peminjaman']['error'] == UPLOAD_ERR_OK) {
        $file_tmp = $_FILES['dok_peminjaman']['tmp_name'];
        $file_name = basename($_FILES['dok_peminjaman']['name']);
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

        $allowed_ext = ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'];
        if (in_array($file_ext, $allowed_ext)) {
            $new_file_name = "peminjaman_" . $id_user . "_" . time() . "." . $file_ext;
            $upload_path = $dokumen_dir . $new_file_name;

            if (move_uploaded_file($file_tmp, $upload_path)) {
                $dok_peminjaman = "assets/dokumen/" . $new_file_name;
            }
        }
    } else if (!empty($data['dok_peminjaman'])) {
        // Handle base64 encoded image
        $base64_data = $data['dok_peminjaman'];

        // Check if it's base64 data
        if (preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $base64_data)) {
            $image_data = base64_decode($base64_data);
            if ($image_data !== false) {
                // Try to determine file type from base64 data
                $finfo = new finfo(FILEINFO_MIME_TYPE);
                $mime_type = $finfo->buffer($image_data);

                $ext = 'jpg'; // default
                if ($mime_type == 'image/png') $ext = 'png';
                else if ($mime_type == 'image/jpeg') $ext = 'jpg';
                else if ($mime_type == 'application/pdf') $ext = 'pdf';

                $new_file_name = "peminjaman_" . $id_user . "_" . time() . "." . $ext;
                $upload_path = $dokumen_dir . $new_file_name;

                if (file_put_contents($upload_path, $image_data)) {
                    $dok_peminjaman = "assets/dokumen/" . $new_file_name;
                }
            }
        } else {
            // It might be a file path already
            $dok_peminjaman = $data['dok_peminjaman'];
        }
    }

    // Process KTM file (FIXED - same handling as dokumen peminjaman)
    if (isset($_FILES['dok_ktm']) && $_FILES['dok_ktm']['error'] == UPLOAD_ERR_OK) {
        $file_tmp = $_FILES['dok_ktm']['tmp_name'];
        $file_name = basename($_FILES['dok_ktm']['name']);
        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

        $allowed_ext = ['jpg', 'jpeg', 'png', 'pdf'];
        if (in_array($file_ext, $allowed_ext)) {
            $new_file_name = "ktm_" . $id_user . "_" . time() . "." . $file_ext;
            $upload_path = $ktm_dir . $new_file_name;

            if (move_uploaded_file($file_tmp, $upload_path)) {
                $dok_ktm = "assets/ktm/" . $new_file_name;
            }
        }
    } else if (!empty($data['dok_ktm'])) {
        // Handle base64 encoded image for KTM (ADDED THIS PART)
        $base64_data = $data['dok_ktm'];

        // Check if it's base64 data
        if (preg_match('/^[a-zA-Z0-9\/\r\n+]*={0,2}$/', $base64_data)) {
            $image_data = base64_decode($base64_data);
            if ($image_data !== false) {
                // Try to determine file type from base64 data
                $finfo = new finfo(FILEINFO_MIME_TYPE);
                $mime_type = $finfo->buffer($image_data);

                $ext = 'jpg'; // default
                if ($mime_type == 'image/png') $ext = 'png';
                else if ($mime_type == 'image/jpeg') $ext = 'jpg';
                else if ($mime_type == 'application/pdf') $ext = 'pdf';

                $new_file_name = "ktm_" . $id_user . "_" . time() . "." . $ext;
                $upload_path = $ktm_dir . $new_file_name;

                if (file_put_contents($upload_path, $image_data)) {
                    $dok_ktm = "assets/ktm/" . $new_file_name;
                }
            }
        } else {
            // It might be a file path already
            $dok_ktm = $data['dok_ktm'];
        }
    }

    // Test the database connection and table existence
    $test_query = "SHOW TABLES LIKE 'peminjaman'";
    $result = $conn->query($test_query);
    if ($result->num_rows == 0) {
        throw new Exception("Table 'peminjaman' does not exist in database");
    }

    // Insert into database using prepared statement
    $sql = "INSERT INTO peminjaman (
                id_user, kode_ruang, nama_ruang, kapasitas, 
                dok_peminjaman, dok_ktm, nama_kegiatan, nama_organisasi,
                tanggal_mulai, waktu_mulai, tanggal_selesai, waktu_selesai,
                status, catatan
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        error_log("Database prepare error: " . $conn->error);
        throw new Exception("Database prepare error: " . $conn->error);
    }

    $stmt->bind_param(
        "ssssssssssssss",
        $id_user,
        $kode_ruang,
        $nama_ruang,
        $kapasitas,
        $dok_peminjaman,
        $dok_ktm,
        $nama_kegiatan,
        $nama_organisasi,
        $tanggal_mulai,
        $waktu_mulai,
        $tanggal_selesai,
        $waktu_selesai,
        $status,
        $catatan
    );

    if (!$stmt->execute()) {
        error_log("Database execution error: " . $stmt->error);
        throw new Exception("Database execution error: " . $stmt->error);
    }

    $id_booking = $conn->insert_id;

    // Close statement and connection
    $stmt->close();
    $conn->close();

    // Success response
    sendResponse([
        "id_booking" => $id_booking,
        "id_user" => $id_user,
        "kode_ruang" => $kode_ruang,
        "nama_ruang" => $nama_ruang,
        "kapasitas" => $kapasitas,
        "dok_peminjaman" => $dok_peminjaman,
        "dok_ktm" => $dok_ktm,
        "nama_kegiatan" => $nama_kegiatan,
        "nama_organisasi" => $nama_organisasi,
        "tanggal_mulai" => $tanggal_mulai,
        "waktu_mulai" => $waktu_mulai,
        "tanggal_selesai" => $tanggal_selesai,
        "waktu_selesai" => $waktu_selesai,
        "status" => $status,
        "catatan" => $catatan,
        "result" => 1,
        "message" => "Peminjaman Ruang Berhasil Diajukan"
    ]);
} catch (Exception $e) {
    // Log the actual error
    error_log("Booking script error: " . $e->getMessage());

    // Clean up if needed
    if (isset($stmt) && $stmt) {
        try {
            $stmt->close();
        } catch (Exception $ex) {
            // Ignore cleanup errors
        }
    }
    if (isset($conn) && $conn) {
        try {
            $conn->close();
        } catch (Exception $ex) {
            // Ignore cleanup errors
        }
    }

    // Error response with more specific message
    sendResponse([
        'status' => 0,
        'result' => 0,
        'message' => $e->getMessage() // Now shows the actual error
    ]);
}
