<?php
include "koneksimysql.php";
header('Content-Type: application/json');

// Menangkap parameter id_peminjaman dari GET atau POST
$id_peminjaman = null;

if (isset($_GET['id_peminjaman'])) {
    $id_peminjaman = $_GET['id_peminjaman'];
} elseif (isset($_POST['id_peminjaman'])) {
    $id_peminjaman = $_POST['id_peminjaman'];
} else {
    // Cek jika request body JSON
    $json = file_get_contents("php://input");
    $data = json_decode($json, true);

    if (isset($data['id_peminjaman'])) {
        $id_peminjaman = $data['id_peminjaman'];
    }
}

// Jika id_peminjaman masih null, kirim error
if ($id_peminjaman === null) {
    echo json_encode(array('error' => 'Parameter id_peminjaman diperlukan'));
    error_log("Error: Parameter id_peminjaman tidak ditemukan dalam request.");
    exit;
}

// Sanitasi input
$id_peminjaman = mysqli_real_escape_string($conn, $id_peminjaman);

// Query ke database
$sql = "SELECT * FROM peminjaman WHERE id_peminjaman = '$id_peminjaman'";
$hasil = mysqli_query($conn, $sql);

// Debugging jika query error
if (!$hasil) {
    echo json_encode(array('error' => 'Query error: ' . mysqli_error($conn)));
    error_log("SQL Error: " . mysqli_error($conn));
    exit;
}

// Ambil hasil
if ($data = mysqli_fetch_object($hasil)) {
    echo json_encode(array(
        'id_peminjaman' => $data->id_peminjaman,
        'id_user' => $data->id_user,
        'kode_ruang' => $data->kode_ruang,
        'nama_ruang' => $data->nama_ruang,
        'kapasitas' => $data->kapasitas,
        'dok_peminjaman' => $data->dok_peminjaman,
        'dok_ktm' => $data->dok_ktm,
        'nama_kegiatan' => $data->nama_kegiatan,
        'nama_organisasi' => $data->nama_organisasi,
        'tanggal_mulai' => $data->tanggal_mulai,
        'waktu_mulai' => $data->waktu_mulai,
        'tanggal_selesai' => $data->tanggal_selesai,
        'waktu_selesai' => $data->waktu_selesai,
        'status' => $data->status,
        'catatan' => $data->catatan
    ));
} else {
    echo json_encode(array('error' => 'Data tidak ditemukan'));
    error_log("Error: Data tidak ditemukan untuk id_peminjaman = " . $id_peminjaman);
}
