<?php

include "koneksimysql.php";
header('Content-Type: application/json');

if (!isset($_GET['customer_id']) || empty($_GET['customer_id'])) {
    echo json_encode(array('error' => 'customer_id parameter is missing or empty'));
    exit();
}

$id_user = $_GET['customer_id'];

$result = array();

$sql = "SELECT
            id_peminjaman,
            id_user,
            kode_ruang,
            nama_ruang,
            kapasitas,
            dok_peminjaman,
            dok_ktm,
            nama_kegiatan,
            nama_organisasi,
            tanggal_mulai,
            waktu_mulai,
            tanggal_selesai,
            waktu_selesai,
            status,
            catatan
        FROM
            `peminjaman`
        WHERE
            id_user = ?
        ORDER BY
            id_peminjaman DESC";

if ($stmt = $conn->prepare($sql)) {
    $stmt->bind_param("s", $id_user); // Menggunakan "s" jika id_user adalah string
    if ($stmt->execute()) {
        $hasil = $stmt->get_result();

        if ($hasil->num_rows > 0) {
            $bookings = array();

            while ($data = $hasil->fetch_object()) {
                $bookings[] = array(
                    'id_peminjaman' => $data->id_peminjaman,
                    'id_user' => $data->id_user,
                    'kode_ruang' => $data->kode_ruang,
                    'nama_ruang' => $data->nama_ruang,
                    'kapasitas' => $data->kapasitas,
                    'dok_peminjaman' => $data->dok_peminjaman,
                    'dok_ktm' => $data->dok_ktm,
                    'nama_kegiatan' => $data->nama_kegiatan,
                    'nama_organisasi' => $data->nama_organisasi,
                    'tanggal_mulai' => $data->tanggal_mulai,
                    'waktu_mulai' => $data->waktu_mulai,
                    'tanggal_selesai' => $data->tanggal_selesai,
                    'waktu_selesai' => $data->waktu_selesai,
                    'status' => $data->status,
                    'catatan' => $data->catatan
                );
            }

            echo json_encode(array('result' => $bookings));
        } else {
            echo json_encode(array('error' => 'No bookings found for the given customer_id'));
        }
    } else {
        echo json_encode(array('error' => 'Failed to execute the SQL query', 'sql_error' => $stmt->error));
    }
    $stmt->close();
} else {
    echo json_encode(array('error' => 'Failed to prepare the SQL statement', 'sql_error' => $conn->error));
}

$conn->close();
